/*
 * Decompiled with CFR 0.152.
 */
package no.ks.kes.jdbc.saga;

import java.sql.ResultSet;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import no.ks.kes.jdbc.CmdTable;
import no.ks.kes.lib.Cmd;
import no.ks.kes.lib.CmdHandler;
import no.ks.kes.lib.CmdSerdes;
import no.ks.kes.lib.CmdWrapper;
import no.ks.kes.lib.CommandQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0014\u0010\u001a\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0018\u00010\u001bH\u0014J\u0016\u0010\u001d\u001a\u00020\u00112\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u001fH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lno/ks/kes/jdbc/saga/SqlServerCommandQueue;", "Lno/ks/kes/lib/CommandQueue;", "dataSource", "Ljavax/sql/DataSource;", "cmdSerdes", "Lno/ks/kes/lib/CmdSerdes;", "cmdHandlers", "", "Lno/ks/kes/lib/CmdHandler;", "schema", "", "(Ljavax/sql/DataSource;Lno/ks/kes/lib/CmdSerdes;Ljava/util/Set;Ljava/lang/String;)V", "template", "Lorg/springframework/jdbc/core/namedparam/NamedParameterJdbcTemplate;", "transactionManager", "Lorg/springframework/jdbc/datasource/DataSourceTransactionManager;", "delete", "", "cmdId", "", "incrementAndSetError", "errorId", "Ljava/util/UUID;", "incrementAndSetNextExecution", "nextExecution", "Ljava/time/Instant;", "nextCmd", "Lno/ks/kes/lib/CmdWrapper;", "Lno/ks/kes/lib/Cmd;", "transactionally", "runnable", "Lkotlin/Function0;", "k-es-jdbc"})
public final class SqlServerCommandQueue
extends CommandQueue {
    @NotNull
    private final CmdSerdes cmdSerdes;
    @Nullable
    private final String schema;
    @NotNull
    private final NamedParameterJdbcTemplate template;
    @NotNull
    private final DataSourceTransactionManager transactionManager;

    public SqlServerCommandQueue(@NotNull DataSource dataSource, @NotNull CmdSerdes cmdSerdes, @NotNull Set<? extends CmdHandler<?>> cmdHandlers, @Nullable String schema) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)cmdSerdes, (String)"cmdSerdes");
        Intrinsics.checkNotNullParameter(cmdHandlers, (String)"cmdHandlers");
        super(cmdHandlers, null, 2, null);
        this.cmdSerdes = cmdSerdes;
        this.schema = schema;
        this.template = new NamedParameterJdbcTemplate(dataSource);
        this.transactionManager = new DataSourceTransactionManager(dataSource);
    }

    public /* synthetic */ SqlServerCommandQueue(DataSource dataSource, CmdSerdes cmdSerdes, Set set, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = null;
        }
        this(dataSource, cmdSerdes, set, string);
    }

    protected void delete(long cmdId) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)cmdId)};
        this.template.update("DELETE FROM " + CmdTable.INSTANCE.qualifiedName(this.schema) + " WHERE id = :id", MapsKt.mutableMapOf((Pair[])pairArray));
    }

    protected void incrementAndSetError(long cmdId, @NotNull UUID errorId) {
        Intrinsics.checkNotNullParameter((Object)errorId, (String)"errorId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)cmdId), TuplesKt.to((Object)"errorId", (Object)errorId)};
        this.template.update("UPDATE " + CmdTable.INSTANCE.qualifiedName(this.schema) + " SET error = 1, errorId = :errorId, retries = retries + 1 WHERE id = :id", MapsKt.mutableMapOf((Pair[])pairArray));
    }

    protected void incrementAndSetNextExecution(long cmdId, @NotNull Instant nextExecution) {
        Intrinsics.checkNotNullParameter((Object)nextExecution, (String)"nextExecution");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)cmdId), TuplesKt.to((Object)"nextExecution", (Object)OffsetDateTime.ofInstant(nextExecution, ZoneOffset.UTC))};
        this.template.update("UPDATE " + CmdTable.INSTANCE.qualifiedName(this.schema) + " SET nextExecution = :nextExecution, retries = retries + 1 WHERE id = :id", MapsKt.mutableMapOf((Pair[])pairArray));
    }

    @Nullable
    protected CmdWrapper<Cmd<?>> nextCmd() {
        List list = this.template.query(" ;WITH cte AS\n                    (\n                        SELECT *,\n                        ROW_NUMBER() OVER (PARTITION BY aggregateId ORDER BY id) AS rn\n                        FROM " + CmdTable.INSTANCE.qualifiedName(this.schema) + "\n                    )\n                    SELECT TOP 1 id, serializationId, aggregateId, retries, data\n                    FROM cte\n                    WITH (XLOCK)\n                    WHERE rn = 1\n                    AND error = 0\n                    AND nextExecution < CURRENT_TIMESTAMP\n                    ORDER BY NEWID()\n                ", (arg_0, arg_1) -> SqlServerCommandQueue.nextCmd$lambda$0(this, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"query(...)");
        return (CmdWrapper)CollectionsKt.singleOrNull((List)list);
    }

    protected void transactionally(@NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        new TransactionTemplate((PlatformTransactionManager)this.transactionManager).execute(arg_0 -> SqlServerCommandQueue.transactionally$lambda$0(runnable, arg_0));
    }

    private static final CmdWrapper nextCmd$lambda$0(SqlServerCommandQueue this$0, ResultSet rs, int n) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        long l = rs.getLong("id");
        CmdSerdes cmdSerdes = this$0.cmdSerdes;
        String string = rs.getString("data");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String string3 = rs.getString("serializationId");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        return new CmdWrapper(l, cmdSerdes.deserialize(byArray, string3), rs.getInt("retries"));
    }

    private static final Unit transactionally$lambda$0(Function0 $runnable, TransactionStatus it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $runnable.invoke();
        return Unit.INSTANCE;
    }
}

