/*
 * Decompiled with CFR 0.152.
 */
package no.ks.kes.test;

import java.util.Set;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import no.ks.kes.lib.AggregateRepository;
import no.ks.kes.lib.Cmd;
import no.ks.kes.lib.CmdHandler;
import no.ks.kes.lib.CmdSerdes;
import no.ks.kes.lib.EventSerdes;
import no.ks.kes.lib.EventSubscriberFactory;
import no.ks.kes.lib.SagaStateSerdes;
import no.ks.kes.serdes.jackson.JacksonSagaStateSerdes;
import no.ks.kes.test.TestAggregateRepository;
import no.ks.kes.test.TestCommandQueue;
import no.ks.kes.test.TestEventStream;
import no.ks.kes.test.TestEventSubscriberFactory;
import no.ks.kes.test.TestEventSubscription;
import no.ks.kes.test.TestProjectionRepository;
import no.ks.kes.test.TestSagaRepository;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010!\u001a\u00020\"2\u0012\b\u0002\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0$J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\"2\b\b\u0002\u0010)\u001a\u00020*R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\f\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006+"}, d2={"Lno/ks/kes/test/KesTestSetup;", "Ljava/lang/AutoCloseable;", "eventSerdes", "Lno/ks/kes/lib/EventSerdes;", "cmdSerdes", "Lno/ks/kes/lib/CmdSerdes;", "(Lno/ks/kes/lib/EventSerdes;Lno/ks/kes/lib/CmdSerdes;)V", "aggregateRepository", "Lno/ks/kes/lib/AggregateRepository;", "getAggregateRepository", "()Lno/ks/kes/lib/AggregateRepository;", "aggregateRepository$delegate", "Lkotlin/Lazy;", "getCmdSerdes", "()Lno/ks/kes/lib/CmdSerdes;", "getEventSerdes", "()Lno/ks/kes/lib/EventSerdes;", "eventStream", "Lno/ks/kes/test/TestEventStream;", "getEventStream", "()Lno/ks/kes/test/TestEventStream;", "projectionRepository", "Lno/ks/kes/test/TestProjectionRepository;", "getProjectionRepository", "()Lno/ks/kes/test/TestProjectionRepository;", "subscriberFactory", "Lno/ks/kes/lib/EventSubscriberFactory;", "Lno/ks/kes/test/TestEventSubscription;", "getSubscriberFactory", "()Lno/ks/kes/lib/EventSubscriberFactory;", "subscriberFactory$delegate", "close", "", "createCommandQueue", "Lno/ks/kes/test/TestCommandQueue;", "cmdHandlers", "", "Lno/ks/kes/lib/CmdHandler;", "createSagaRepository", "Lno/ks/kes/test/TestSagaRepository;", "commandQueue", "sagaStateSerdes", "Lno/ks/kes/lib/SagaStateSerdes;", "k-es-test-support"})
public final class KesTestSetup
implements AutoCloseable {
    @NotNull
    private final EventSerdes eventSerdes;
    @NotNull
    private final CmdSerdes cmdSerdes;
    @NotNull
    private final TestEventStream eventStream;
    @NotNull
    private final Lazy subscriberFactory$delegate;
    @NotNull
    private final Lazy aggregateRepository$delegate;
    @NotNull
    private final TestProjectionRepository projectionRepository;

    public KesTestSetup(@NotNull EventSerdes eventSerdes, @NotNull CmdSerdes cmdSerdes) {
        Intrinsics.checkNotNullParameter((Object)eventSerdes, (String)"eventSerdes");
        Intrinsics.checkNotNullParameter((Object)cmdSerdes, (String)"cmdSerdes");
        this.eventSerdes = eventSerdes;
        this.cmdSerdes = cmdSerdes;
        this.eventStream = new TestEventStream();
        this.subscriberFactory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TestEventSubscriberFactory>(this){
            final /* synthetic */ KesTestSetup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TestEventSubscriberFactory invoke() {
                return new TestEventSubscriberFactory(this.this$0.getEventSerdes(), this.this$0.getEventStream());
            }
        }));
        this.aggregateRepository$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TestAggregateRepository>(this){
            final /* synthetic */ KesTestSetup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TestAggregateRepository invoke() {
                return new TestAggregateRepository(this.this$0.getEventSerdes(), this.this$0.getEventStream());
            }
        }));
        this.projectionRepository = new TestProjectionRepository();
    }

    @NotNull
    public final EventSerdes getEventSerdes() {
        return this.eventSerdes;
    }

    @NotNull
    public final CmdSerdes getCmdSerdes() {
        return this.cmdSerdes;
    }

    @NotNull
    public final TestEventStream getEventStream() {
        return this.eventStream;
    }

    @NotNull
    public final EventSubscriberFactory<TestEventSubscription> getSubscriberFactory() {
        Lazy lazy = this.subscriberFactory$delegate;
        return (EventSubscriberFactory)lazy.getValue();
    }

    @NotNull
    public final AggregateRepository getAggregateRepository() {
        Lazy lazy = this.aggregateRepository$delegate;
        return (AggregateRepository)lazy.getValue();
    }

    @NotNull
    public final TestCommandQueue createCommandQueue(@NotNull Set<? extends CmdHandler<?>> cmdHandlers) {
        Intrinsics.checkNotNullParameter(cmdHandlers, (String)"cmdHandlers");
        return new TestCommandQueue(cmdHandlers, this.cmdSerdes);
    }

    public static /* synthetic */ TestCommandQueue createCommandQueue$default(KesTestSetup kesTestSetup, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        return kesTestSetup.createCommandQueue(set);
    }

    @NotNull
    public final TestSagaRepository createSagaRepository(@NotNull TestCommandQueue commandQueue, @NotNull SagaStateSerdes sagaStateSerdes) {
        Intrinsics.checkNotNullParameter((Object)((Object)commandQueue), (String)"commandQueue");
        Intrinsics.checkNotNullParameter((Object)sagaStateSerdes, (String)"sagaStateSerdes");
        return new TestSagaRepository(sagaStateSerdes, (Function2)new Function2<UUID, Cmd<?>, Unit>(commandQueue){
            final /* synthetic */ TestCommandQueue $commandQueue;
            {
                this.$commandQueue = $commandQueue;
                super(2);
            }

            public final void invoke(@NotNull UUID aggregateId, @NotNull Cmd<?> command) {
                Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
                Intrinsics.checkNotNullParameter(command, (String)"command");
                this.$commandQueue.addToQueue(aggregateId, command);
            }
        });
    }

    public static /* synthetic */ TestSagaRepository createSagaRepository$default(KesTestSetup kesTestSetup, TestCommandQueue testCommandQueue, SagaStateSerdes sagaStateSerdes, int n, Object object) {
        if ((n & 2) != 0) {
            sagaStateSerdes = (SagaStateSerdes)new JacksonSagaStateSerdes(null, 1, null);
        }
        return kesTestSetup.createSagaRepository(testCommandQueue, sagaStateSerdes);
    }

    @NotNull
    public final TestProjectionRepository getProjectionRepository() {
        return this.projectionRepository;
    }

    @Override
    public void close() {
        this.eventStream.close();
    }
}

