/*
 * Decompiled with CFR 0.152.
 */
package no.ks.kes.test;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import no.ks.kes.lib.Cmd;
import no.ks.kes.lib.CmdHandler;
import no.ks.kes.lib.CmdSerdes;
import no.ks.kes.lib.CmdWrapper;
import no.ks.kes.lib.CommandQueue;
import no.ks.kes.test.CmdStatus;
import no.ks.kes.test.KesTestSetupKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\fH\u0014J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0015H\u0014J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0014\u0010\u001f\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0018\u00010 H\u0014J\u0016\u0010!\u001a\u00020\u00132\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130#H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Lno/ks/kes/test/TestCommandQueue;", "Lno/ks/kes/lib/CommandQueue;", "cmdHandlers", "", "Lno/ks/kes/lib/CmdHandler;", "cmdSerdes", "Lno/ks/kes/lib/CmdSerdes;", "(Ljava/util/Set;Lno/ks/kes/lib/CmdSerdes;)V", "cmdIdSequence", "Ljava/util/concurrent/atomic/AtomicLong;", "commandQueue", "", "", "Lno/ks/kes/test/CmdStatus;", "commandsAwaiting", "Ljava/util/SortedMap;", "getCommandsAwaiting", "()Ljava/util/SortedMap;", "addToQueue", "", "aggregateId", "Ljava/util/UUID;", "cmd", "Lno/ks/kes/lib/Cmd;", "delete", "cmdId", "incrementAndSetError", "errorId", "incrementAndSetNextExecution", "nextExecution", "Ljava/time/Instant;", "nextCmd", "Lno/ks/kes/lib/CmdWrapper;", "transactionally", "runnable", "Lkotlin/Function0;", "k-es-test-support"})
public final class TestCommandQueue
extends CommandQueue {
    @NotNull
    private final CmdSerdes cmdSerdes;
    @NotNull
    private final AtomicLong cmdIdSequence;
    @NotNull
    private final Map<Long, CmdStatus> commandQueue;

    public TestCommandQueue(@NotNull Set<? extends CmdHandler<?>> cmdHandlers, @NotNull CmdSerdes cmdSerdes) {
        Intrinsics.checkNotNullParameter(cmdHandlers, (String)"cmdHandlers");
        Intrinsics.checkNotNullParameter((Object)cmdSerdes, (String)"cmdSerdes");
        super(cmdHandlers, null, 2, null);
        this.cmdSerdes = cmdSerdes;
        this.cmdIdSequence = new AtomicLong(0L);
        this.commandQueue = new LinkedHashMap();
    }

    private final SortedMap<Long, CmdStatus> getCommandsAwaiting() {
        Map<Long, CmdStatus> $this$filterValues$iv = this.commandQueue;
        boolean $i$f$filterValues = false;
        LinkedHashMap<Long, CmdStatus> result$iv = new LinkedHashMap<Long, CmdStatus>();
        for (Map.Entry<Long, CmdStatus> entry$iv : $this$filterValues$iv.entrySet()) {
            CmdStatus it = entry$iv.getValue();
            boolean bl = false;
            if (!Instant.now().isAfter(it.getNextExecution())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return MapsKt.toSortedMap((Map)result$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                long it = ((Number)a).longValue();
                boolean bl = false;
                Comparable comparable = Long.valueOf(it);
                it = ((Number)b).longValue();
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it));
            }
        });
    }

    protected void delete(long cmdId) {
        Long l = cmdId;
        this.commandQueue.remove(l);
    }

    protected void incrementAndSetError(long cmdId, @NotNull UUID errorId) {
        block0: {
            CmdStatus cmdStatus;
            Intrinsics.checkNotNullParameter((Object)errorId, (String)"errorId");
            CmdStatus cmdStatus2 = this.commandQueue.get(cmdId);
            if (cmdStatus2 == null) break block0;
            CmdStatus $this$incrementAndSetError_u24lambda_u242 = cmdStatus = cmdStatus2;
            boolean bl = false;
            Long l = cmdId;
            this.commandQueue.put(l, CmdStatus.copy$default($this$incrementAndSetError_u24lambda_u242, null, null, errorId, 0, null, null, 59, null));
        }
    }

    protected void incrementAndSetNextExecution(long cmdId, @NotNull Instant nextExecution) {
        block0: {
            CmdStatus cmdStatus;
            Intrinsics.checkNotNullParameter((Object)nextExecution, (String)"nextExecution");
            CmdStatus cmdStatus2 = this.commandQueue.get(cmdId);
            if (cmdStatus2 == null) break block0;
            CmdStatus $this$incrementAndSetNextExecution_u24lambda_u243 = cmdStatus = cmdStatus2;
            boolean bl = false;
            Map<Long, CmdStatus> map = this.commandQueue;
            Long l = cmdId;
            int n = $this$incrementAndSetNextExecution_u24lambda_u243.getRetries() + 1;
            CmdStatus cmdStatus3 = CmdStatus.copy$default($this$incrementAndSetNextExecution_u24lambda_u243, null, null, null, n, nextExecution, null, 39, null);
            map.put(l, cmdStatus3);
        }
    }

    @Nullable
    protected CmdWrapper<Cmd<?>> nextCmd() {
        CmdWrapper cmdWrapper;
        CmdWrapper cmdWrapper2;
        Pair pair = (Pair)CollectionsKt.firstOrNull((List)MapsKt.toList((Map)this.getCommandsAwaiting()));
        if (pair != null) {
            Pair it = pair;
            boolean bl = false;
            Long l = (Long)it.getFirst();
            int n = ((CmdStatus)it.getSecond()).getRetries();
            byte[] byArray = ((CmdStatus)it.getSecond()).getDeserializedCommd().getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            Cmd cmd = this.cmdSerdes.deserialize(byArray, ((CmdStatus)it.getSecond()).getSerializationId());
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"first");
            cmdWrapper2 = new CmdWrapper(l.longValue(), cmd, n);
        } else {
            cmdWrapper2 = null;
        }
        CmdWrapper it = cmdWrapper = cmdWrapper2;
        boolean bl = false;
        KesTestSetupKt.access$getLOG$p().debug((Function0)new Function0<Object>(it){
            final /* synthetic */ CmdWrapper<Cmd<?>> $it;
            {
                this.$it = $it;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "nextCmd is: " + this.$it;
            }
        });
        return cmdWrapper;
    }

    protected void transactionally(@NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        runnable.invoke();
    }

    public final void addToQueue(@NotNull UUID aggregateId, @NotNull Cmd<?> cmd) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        Intrinsics.checkNotNullParameter(cmd, (String)"cmd");
        Map<Long, CmdStatus> map = this.commandQueue;
        Long l = this.cmdIdSequence.incrementAndGet();
        String string = this.cmdSerdes.getSerializationId(Reflection.getOrCreateKotlinClass(cmd.getClass()));
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        Object object = this.cmdSerdes.serialize(cmd);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        object = TuplesKt.to((Object)l, (Object)new CmdStatus(aggregateId, string, null, 0, instant, new String((byte[])object, charset2), 12, null));
        map.put((Long)object.getFirst(), (CmdStatus)object.getSecond());
    }
}

