/*
 * Decompiled with CFR 0.152.
 */
package no.ks.kes.test;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import no.ks.kes.lib.Cmd;
import no.ks.kes.lib.HwmTrackerRepository;
import no.ks.kes.lib.Saga;
import no.ks.kes.lib.SagaRepository;
import no.ks.kes.lib.SagaStateSerdes;
import no.ks.kes.test.KesTestSetupKt;
import no.ks.kes.test.TestHwmTrackerRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003,-.B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001c\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0016J7\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\b\b\u0000\u0010\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u001d0#H\u0016\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\u00020\b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0'H\u0016J\u0016\u0010(\u001a\u00020\b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0016R$\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lno/ks/kes/test/TestSagaRepository;", "Lno/ks/kes/lib/SagaRepository;", "sagaStateSerdes", "Lno/ks/kes/lib/SagaStateSerdes;", "addCommandToQueue", "Lkotlin/Function2;", "Ljava/util/UUID;", "Lno/ks/kes/lib/Cmd;", "", "(Lno/ks/kes/lib/SagaStateSerdes;Lkotlin/jvm/functions/Function2;)V", "hwmTracker", "Lno/ks/kes/lib/HwmTrackerRepository;", "getHwmTracker", "()Lno/ks/kes/lib/HwmTrackerRepository;", "sagaStates", "", "Lno/ks/kes/test/TestSagaRepository$SagaKey;", "", "scheduledExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "timeouts", "Lno/ks/kes/test/TestSagaRepository$TimeoutKey;", "Lno/ks/kes/test/TestSagaRepository$TimeoutEntry;", "deleteTimeout", "timeout", "Lno/ks/kes/lib/SagaRepository$Timeout;", "getReadyTimeouts", "getSagaState", "T", "", "correlationId", "serializationId", "", "sagaStateClass", "Lkotlin/reflect/KClass;", "(Ljava/util/UUID;Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "transactionally", "runnable", "Lkotlin/Function0;", "update", "states", "", "Lno/ks/kes/lib/SagaRepository$Operation;", "SagaKey", "TimeoutEntry", "TimeoutKey", "k-es-test-support"})
@SourceDebugExtension(value={"SMAP\nKesTestSetup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KesTestSetup.kt\nno/ks/kes/test/TestSagaRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,298:1\n800#2,11:299\n1855#2,2:310\n800#2,11:312\n1855#2:323\n1855#2,2:324\n1856#2:326\n800#2,11:327\n1855#2,2:338\n1360#2:340\n1446#2,5:341\n1855#2,2:346\n515#3:348\n500#3,6:349\n*S KotlinDebug\n*F\n+ 1 KesTestSetup.kt\nno/ks/kes/test/TestSagaRepository\n*L\n256#1:299,11\n257#1:310,2\n261#1:312,11\n261#1:323\n262#1:324,2\n261#1:326\n268#1:327,11\n268#1:338,2\n277#1:340\n277#1:341,5\n277#1:346,2\n283#1:348\n283#1:349,6\n*E\n"})
public final class TestSagaRepository
implements SagaRepository {
    @NotNull
    private final SagaStateSerdes sagaStateSerdes;
    @NotNull
    private final Function2<UUID, Cmd<?>, Unit> addCommandToQueue;
    private final ScheduledExecutorService scheduledExecutor;
    @NotNull
    private final Map<SagaKey, byte[]> sagaStates;
    @NotNull
    private final Map<TimeoutKey, TimeoutEntry> timeouts;
    @NotNull
    private final HwmTrackerRepository hwmTracker;

    public TestSagaRepository(@NotNull SagaStateSerdes sagaStateSerdes, @NotNull Function2<? super UUID, ? super Cmd<?>, Unit> addCommandToQueue) {
        Intrinsics.checkNotNullParameter((Object)sagaStateSerdes, (String)"sagaStateSerdes");
        Intrinsics.checkNotNullParameter(addCommandToQueue, (String)"addCommandToQueue");
        this.sagaStateSerdes = sagaStateSerdes;
        this.addCommandToQueue = addCommandToQueue;
        this.scheduledExecutor = Executors.newScheduledThreadPool(5);
        this.sagaStates = new LinkedHashMap();
        this.timeouts = new LinkedHashMap();
        this.hwmTracker = new TestHwmTrackerRepository();
    }

    @Nullable
    public <T> T getSagaState(@NotNull UUID correlationId, @NotNull String serializationId, @NotNull KClass<T> sagaStateClass) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        Intrinsics.checkNotNullParameter((Object)serializationId, (String)"serializationId");
        Intrinsics.checkNotNullParameter(sagaStateClass, (String)"sagaStateClass");
        byte[] byArray = this.sagaStates.get(new SagaKey(correlationId, serializationId));
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl = false;
            object = this.sagaStateSerdes.deserialize(it, sagaStateClass);
        } else {
            object = null;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull Set<? extends SagaRepository.Operation> states) {
        void $this$flatMapTo$iv$iv;
        Object object;
        Object element$iv$iv2;
        Object $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(states, (String)"states");
        KesTestSetupKt.access$getLOG$p().info((Function0)new Function0<Object>(states){
            final /* synthetic */ Set<SagaRepository.Operation> $states;
            {
                this.$states = $states;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Updating sagas: " + this.$states;
            }
        });
        Iterable $this$filterIsInstance$iv = states;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv2 = iterator.next();
            if (!(element$iv$iv2 instanceof SagaRepository.Operation.Insert)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SagaRepository.Operation.Insert it = (SagaRepository.Operation.Insert)element$iv;
            boolean bl = false;
            element$iv$iv2 = this.sagaStates;
            Pair pair = TuplesKt.to((Object)new SagaKey(it.getCorrelationId(), it.getSerializationId()), (Object)this.sagaStateSerdes.serialize(it.getNewState()));
            element$iv$iv2.put((Object)pair.getFirst(), (Object)pair.getSecond());
        }
        $this$filterIsInstance$iv = states;
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        Iterator bl = $this$filterIsInstanceTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv2 = bl.next();
            if (!(element$iv$iv2 instanceof SagaRepository.Operation.SagaUpdate)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SagaRepository.Operation.SagaUpdate it = (SagaRepository.Operation.SagaUpdate)element$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = it.getTimeouts();
            boolean $i$f$forEach2 = false;
            object = $this$forEach$iv2.iterator();
            while (object.hasNext()) {
                Object element$iv2 = object.next();
                Saga.Timeout timeout2 = (Saga.Timeout)element$iv2;
                boolean bl3 = false;
                Map<TimeoutKey, TimeoutEntry> map = this.timeouts;
                UUID uUID = it.getCorrelationId();
                String string = it.getSerializationId();
                String string2 = timeout2.getTimeoutId();
                TimeoutKey timeoutKey = new TimeoutKey(string, uUID, string2);
                Instant instant = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
                uUID = TuplesKt.to((Object)timeoutKey, (Object)new TimeoutEntry(instant, 0, 2, null));
                map.put((TimeoutKey)uUID.getFirst(), (TimeoutEntry)uUID.getSecond());
            }
        }
        $this$filterIsInstance$iv = states;
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        Iterator bl2 = $this$filterIsInstanceTo$iv$iv.iterator();
        while (bl2.hasNext()) {
            element$iv$iv2 = bl2.next();
            if (!(element$iv$iv2 instanceof SagaRepository.Operation.SagaUpdate)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SagaRepository.Operation.SagaUpdate sagaUpdate = (SagaRepository.Operation.SagaUpdate)element$iv;
            boolean bl4 = false;
            SagaKey sagaKey = new SagaKey(sagaUpdate.getCorrelationId(), sagaUpdate.getSerializationId());
            boolean bl5 = false;
            if (!this.sagaStates.containsKey(sagaKey)) continue;
            Object object2 = sagaUpdate;
            if (object2 == null || (object2 = object2.getNewState()) == null) continue;
            Object $this$update_u24lambda_u246_u24lambda_u245_u24lambda_u244 = object = object2;
            boolean bl6 = false;
            this.sagaStates.put(sagaKey, this.sagaStateSerdes.serialize($this$update_u24lambda_u246_u24lambda_u245_u24lambda_u244));
        }
        Iterable $this$flatMap$iv = states;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
            SagaRepository.Operation it = (SagaRepository.Operation)element$iv$iv2;
            boolean bl7 = false;
            Iterable list$iv$iv = it.getCommands();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Cmd it = (Cmd)element$iv;
            boolean bl8 = false;
            this.addCommandToQueue.invoke((Object)it.getAggregateId(), (Object)it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public SagaRepository.Timeout getReadyTimeouts() {
        SagaRepository.Timeout timeout2;
        void $this$filterTo$iv$iv;
        Map<TimeoutKey, TimeoutEntry> $this$filter$iv = this.timeouts;
        boolean $i$f$filter = false;
        Map<TimeoutKey, TimeoutEntry> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(((TimeoutEntry)entry.getValue()).getError() == 0 && ((TimeoutEntry)entry.getValue()).getTimeout().isBefore(Instant.now()))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Pair pair = (Pair)CollectionsKt.firstOrNull((List)MapsKt.toList((Map)destination$iv$iv));
        if (pair != null) {
            Pair it = pair;
            boolean bl = false;
            timeout2 = new SagaRepository.Timeout(((TimeoutKey)it.getFirst()).getCorrelationId(), ((TimeoutKey)it.getFirst()).getSerializationId(), ((TimeoutKey)it.getFirst()).getTimeoutId());
        } else {
            timeout2 = null;
        }
        return timeout2;
    }

    public void deleteTimeout(@NotNull SagaRepository.Timeout timeout2) {
        Intrinsics.checkNotNullParameter((Object)timeout2, (String)"timeout");
        this.timeouts.remove(new TimeoutKey(timeout2.getSagaSerializationId(), timeout2.getSagaCorrelationId(), timeout2.getTimeoutId()));
    }

    public void transactionally(@NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        runnable.invoke();
    }

    @NotNull
    public HwmTrackerRepository getHwmTracker() {
        return this.hwmTracker;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lno/ks/kes/test/TestSagaRepository$SagaKey;", "", "correlationId", "Ljava/util/UUID;", "serializationId", "", "(Ljava/util/UUID;Ljava/lang/String;)V", "getCorrelationId", "()Ljava/util/UUID;", "getSerializationId", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "k-es-test-support"})
    private static final class SagaKey {
        @NotNull
        private final UUID correlationId;
        @NotNull
        private final String serializationId;

        public SagaKey(@NotNull UUID correlationId, @NotNull String serializationId) {
            Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
            Intrinsics.checkNotNullParameter((Object)serializationId, (String)"serializationId");
            this.correlationId = correlationId;
            this.serializationId = serializationId;
        }

        @NotNull
        public final UUID getCorrelationId() {
            return this.correlationId;
        }

        @NotNull
        public final String getSerializationId() {
            return this.serializationId;
        }

        @NotNull
        public final UUID component1() {
            return this.correlationId;
        }

        @NotNull
        public final String component2() {
            return this.serializationId;
        }

        @NotNull
        public final SagaKey copy(@NotNull UUID correlationId, @NotNull String serializationId) {
            Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
            Intrinsics.checkNotNullParameter((Object)serializationId, (String)"serializationId");
            return new SagaKey(correlationId, serializationId);
        }

        public static /* synthetic */ SagaKey copy$default(SagaKey sagaKey, UUID uUID, String string, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = sagaKey.correlationId;
            }
            if ((n & 2) != 0) {
                string = sagaKey.serializationId;
            }
            return sagaKey.copy(uUID, string);
        }

        @NotNull
        public String toString() {
            return "SagaKey(correlationId=" + this.correlationId + ", serializationId=" + this.serializationId + ")";
        }

        public int hashCode() {
            int result = this.correlationId.hashCode();
            result = result * 31 + this.serializationId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SagaKey)) {
                return false;
            }
            SagaKey sagaKey = (SagaKey)other;
            if (!Intrinsics.areEqual((Object)this.correlationId, (Object)sagaKey.correlationId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.serializationId, (Object)sagaKey.serializationId);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lno/ks/kes/test/TestSagaRepository$TimeoutEntry;", "", "timeout", "Ljava/time/Instant;", "error", "", "(Ljava/time/Instant;I)V", "getError", "()I", "getTimeout", "()Ljava/time/Instant;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "k-es-test-support"})
    private static final class TimeoutEntry {
        @NotNull
        private final Instant timeout;
        private final int error;

        public TimeoutEntry(@NotNull Instant timeout2, int error) {
            Intrinsics.checkNotNullParameter((Object)timeout2, (String)"timeout");
            this.timeout = timeout2;
            this.error = error;
        }

        public /* synthetic */ TimeoutEntry(Instant instant, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(instant, n);
        }

        @NotNull
        public final Instant getTimeout() {
            return this.timeout;
        }

        public final int getError() {
            return this.error;
        }

        @NotNull
        public final Instant component1() {
            return this.timeout;
        }

        public final int component2() {
            return this.error;
        }

        @NotNull
        public final TimeoutEntry copy(@NotNull Instant timeout2, int error) {
            Intrinsics.checkNotNullParameter((Object)timeout2, (String)"timeout");
            return new TimeoutEntry(timeout2, error);
        }

        public static /* synthetic */ TimeoutEntry copy$default(TimeoutEntry timeoutEntry, Instant instant, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                instant = timeoutEntry.timeout;
            }
            if ((n2 & 2) != 0) {
                n = timeoutEntry.error;
            }
            return timeoutEntry.copy(instant, n);
        }

        @NotNull
        public String toString() {
            return "TimeoutEntry(timeout=" + this.timeout + ", error=" + this.error + ")";
        }

        public int hashCode() {
            int result = this.timeout.hashCode();
            result = result * 31 + Integer.hashCode(this.error);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TimeoutEntry)) {
                return false;
            }
            TimeoutEntry timeoutEntry = (TimeoutEntry)other;
            if (!Intrinsics.areEqual((Object)this.timeout, (Object)timeoutEntry.timeout)) {
                return false;
            }
            return this.error == timeoutEntry.error;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lno/ks/kes/test/TestSagaRepository$TimeoutKey;", "", "serializationId", "", "correlationId", "Ljava/util/UUID;", "timeoutId", "(Ljava/lang/String;Ljava/util/UUID;Ljava/lang/String;)V", "getCorrelationId", "()Ljava/util/UUID;", "getSerializationId", "()Ljava/lang/String;", "getTimeoutId", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "k-es-test-support"})
    private static final class TimeoutKey {
        @NotNull
        private final String serializationId;
        @NotNull
        private final UUID correlationId;
        @NotNull
        private final String timeoutId;

        public TimeoutKey(@NotNull String serializationId, @NotNull UUID correlationId, @NotNull String timeoutId) {
            Intrinsics.checkNotNullParameter((Object)serializationId, (String)"serializationId");
            Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
            Intrinsics.checkNotNullParameter((Object)timeoutId, (String)"timeoutId");
            this.serializationId = serializationId;
            this.correlationId = correlationId;
            this.timeoutId = timeoutId;
        }

        @NotNull
        public final String getSerializationId() {
            return this.serializationId;
        }

        @NotNull
        public final UUID getCorrelationId() {
            return this.correlationId;
        }

        @NotNull
        public final String getTimeoutId() {
            return this.timeoutId;
        }

        @NotNull
        public final String component1() {
            return this.serializationId;
        }

        @NotNull
        public final UUID component2() {
            return this.correlationId;
        }

        @NotNull
        public final String component3() {
            return this.timeoutId;
        }

        @NotNull
        public final TimeoutKey copy(@NotNull String serializationId, @NotNull UUID correlationId, @NotNull String timeoutId) {
            Intrinsics.checkNotNullParameter((Object)serializationId, (String)"serializationId");
            Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
            Intrinsics.checkNotNullParameter((Object)timeoutId, (String)"timeoutId");
            return new TimeoutKey(serializationId, correlationId, timeoutId);
        }

        public static /* synthetic */ TimeoutKey copy$default(TimeoutKey timeoutKey, String string, UUID uUID, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = timeoutKey.serializationId;
            }
            if ((n & 2) != 0) {
                uUID = timeoutKey.correlationId;
            }
            if ((n & 4) != 0) {
                string2 = timeoutKey.timeoutId;
            }
            return timeoutKey.copy(string, uUID, string2);
        }

        @NotNull
        public String toString() {
            return "TimeoutKey(serializationId=" + this.serializationId + ", correlationId=" + this.correlationId + ", timeoutId=" + this.timeoutId + ")";
        }

        public int hashCode() {
            int result = this.serializationId.hashCode();
            result = result * 31 + this.correlationId.hashCode();
            result = result * 31 + this.timeoutId.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TimeoutKey)) {
                return false;
            }
            TimeoutKey timeoutKey = (TimeoutKey)other;
            if (!Intrinsics.areEqual((Object)this.serializationId, (Object)timeoutKey.serializationId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.correlationId, (Object)timeoutKey.correlationId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.timeoutId, (Object)timeoutKey.timeoutId);
        }
    }
}

