/*
 * Decompiled with CFR 0.152.
 */
package no.nav.arxaas.hierarchy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import no.nav.arxaas.hierarchy.DateBasedHierarchyBuilder;
import no.nav.arxaas.hierarchy.Hierarchy;
import no.nav.arxaas.hierarchy.HierarchyBuilder;
import org.deidentifier.arx.DataType;
import org.deidentifier.arx.aggregates.HierarchyBuilderDate;

public class DateBasedHierarchyBuilder
implements HierarchyBuilder {
    @NotNull
    private final String dateFormat;
    @NotNull
    private final List<Granularity> granularities;

    @JsonCreator
    public DateBasedHierarchyBuilder(String dateFormat, List<Granularity> granularities) {
        Objects.requireNonNull(dateFormat, "dateFormat should not be null");
        Objects.requireNonNull(granularities, "granularities should not be null");
        if (granularities.isEmpty()) {
            throw new IllegalArgumentException("granularities cannot be empty");
        }
        this.dateFormat = dateFormat;
        this.granularities = granularities;
    }

    public Hierarchy build(String[] column) {
        DataType dateType = DataType.createDate((String)this.dateFormat);
        org.deidentifier.arx.aggregates.HierarchyBuilder builder = HierarchyBuilderDate.create((DataType)dateType, (HierarchyBuilderDate.Granularity[])this.arxGranularities());
        builder.prepare(column);
        return new Hierarchy(builder.build().getHierarchy());
    }

    private HierarchyBuilderDate.Granularity[] arxGranularities() {
        return (HierarchyBuilderDate.Granularity[])this.granularities.stream().map(rec$ -> ((Granularity)rec$).arxGranularity()).toArray(HierarchyBuilderDate.Granularity[]::new);
    }

    @JsonGetter(value="dateFormat")
    String getDateFormat() {
        return this.dateFormat;
    }

    @JsonGetter(value="granularities")
    List<Granularity> getGranularities() {
        return this.granularities;
    }
}

