/*
 * Decompiled with CFR 0.152.
 */
package no.nav.arxaas.model.anonymity;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import no.nav.arxaas.model.AttributeGeneralizationRow;
import org.deidentifier.arx.ARXLattice;
import org.deidentifier.arx.ARXResult;

/*
 * Exception performing whole class analysis ignored.
 */
public class AnonymizationMetrics {
    private List<AttributeGeneralizationRow> attributeGeneralization;
    private Long processTimeMillisecounds;
    private Set privacyModels;

    public AnonymizationMetrics(ARXResult result) {
        this.attributeGeneralization = AnonymizationMetrics.gatherGeneralizationAttributes((ARXResult)result);
        this.processTimeMillisecounds = AnonymizationMetrics.gatherProcessTime((ARXResult)result);
        this.privacyModels = AnonymizationMetrics.gatherPrivacyModels((ARXResult)result);
    }

    @JsonCreator
    private AnonymizationMetrics(List<AttributeGeneralizationRow> attributeGeneralization, Long processTimeMillisecounds, Set privacyModels) {
        this.attributeGeneralization = attributeGeneralization;
        this.processTimeMillisecounds = processTimeMillisecounds;
        this.privacyModels = privacyModels;
    }

    private static List<AttributeGeneralizationRow> gatherGeneralizationAttributes(ARXResult result) {
        ArrayList<AttributeGeneralizationRow> attributeGeneralizationList = new ArrayList<AttributeGeneralizationRow>();
        ARXLattice.ARXNode node = result.getOutput().getTransformation();
        for (String attribute : node.getQuasiIdentifyingAttributes()) {
            attributeGeneralizationList.add(new AttributeGeneralizationRow(attribute, result.getOutput().getDefinition().getAttributeType(attribute).toString(), node.getGeneralization(attribute)));
        }
        return attributeGeneralizationList;
    }

    private static long gatherProcessTime(ARXResult result) {
        return result.getTime();
    }

    private static Set gatherPrivacyModels(ARXResult result) {
        return result.getConfiguration().getPrivacyModels();
    }

    public List<AttributeGeneralizationRow> getAttributeGeneralization() {
        return this.attributeGeneralization;
    }

    public Long getProcessTimeMillisecounds() {
        return this.processTimeMillisecounds;
    }

    public Set getPrivacyModels() {
        return this.privacyModels;
    }
}

