/*
 * Decompiled with CFR 0.152.
 */
package no.nav.arxaas.model.risk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import no.nav.arxaas.model.risk.DistributionOfRisk;
import org.deidentifier.arx.risk.RiskEstimateBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class DistributionOfRisk {
    static final String[] interval = new String[]{"[0,1e-6)", "[1e-6,1e-5)", "[1e-5,0.0001)", "[0.0001,0.001)", "[0.001,0.01)", "[0.01,0.1)", "[0.1,1)", "[1,2)", "[2,3)", "[3,4)", "[4,5)", "[5,6)", "[6,7)", "[7,8)", "[8,9)", "[9,10)", "[10,12.5)", "[12.5,14.3)", "[14.3,16.7)", "[16.7,20)", "[20,25)", "[25,33.4)", "[33.4,50)", "[50,100]"};
    private final List<RiskInterval> riskIntervalList;

    @JsonCreator
    private DistributionOfRisk(List<RiskInterval> riskIntervalList) {
        this.riskIntervalList = riskIntervalList;
    }

    @JsonGetter
    public List<RiskInterval> getRiskIntervalList() {
        return this.riskIntervalList;
    }

    static DistributionOfRisk createFromRiskAndMaxRisk(double[] recordsOfRiskWithinInterval, double[] recordsOfMaximalRiskWithinInterval) {
        ArrayList<RiskInterval> listOfDistributionOfRiskInterval = new ArrayList<RiskInterval>();
        for (int x = recordsOfRiskWithinInterval.length - 1; x >= 0; --x) {
            RiskInterval riskInterval = new RiskInterval(interval[x], recordsOfRiskWithinInterval[x], recordsOfMaximalRiskWithinInterval[x]);
            listOfDistributionOfRiskInterval.add(riskInterval);
        }
        return new DistributionOfRisk(listOfDistributionOfRiskInterval);
    }

    public static DistributionOfRisk create(RiskEstimateBuilder riskEstimateBuilder) {
        return DistributionOfRisk.createFromRiskAndMaxRisk((double[])DistributionOfRisk.distributionOfRecordsWithRisk((RiskEstimateBuilder)riskEstimateBuilder), (double[])DistributionOfRisk.distributionOfRecordsWithMaximalRisk((RiskEstimateBuilder)riskEstimateBuilder));
    }

    private static double[] distributionOfRecordsWithRisk(RiskEstimateBuilder riskEstimateBuilder) {
        return riskEstimateBuilder.getSampleBasedRiskDistribution().getFractionOfRecordsForRiskThresholds();
    }

    private static double[] distributionOfRecordsWithMaximalRisk(RiskEstimateBuilder riskEstimateBuilder) {
        return riskEstimateBuilder.getSampleBasedRiskDistribution().getFractionOfRecordsForCumulativeRiskThresholds();
    }

    public String toString() {
        return "DistributionOfRisk{riskIntervalList=" + this.riskIntervalList + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributionOfRisk that = (DistributionOfRisk)o;
        return this.hashCode() == that.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.riskIntervalList);
    }
}

