/*
 * Decompiled with CFR 0.152.
 */
package no.nav.arxaas.controller;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import no.nav.arxaas.model.FormMetaDataRequest;
import no.nav.arxaas.model.Request;
import no.nav.arxaas.model.risk.RiskProfile;
import no.nav.arxaas.service.AnalyzationService;
import no.nav.arxaas.service.LoggerService;
import no.nav.arxaas.utils.FormDataFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@CrossOrigin
@RestController
@RequestMapping(value={"/api/analyze/file"})
public class FormDataAnalyzationController {
    private final AnalyzationService analyzationService;
    private final LoggerService loggerService;
    private final FormDataFactory formDataFactory;

    @Autowired
    FormDataAnalyzationController(AnalyzationService analyzationService, LoggerService loggerService, FormDataFactory formDataFactory) {
        this.analyzationService = analyzationService;
        this.loggerService = loggerService;
        this.formDataFactory = formDataFactory;
    }

    @PostMapping
    public RiskProfile getPayloadAnalyzeFromFormData(@RequestPart(value="file") MultipartFile file, @RequestPart(value="metadata") @Valid FormMetaDataRequest metadata, HttpServletRequest request) {
        long requestRecivedTime = System.currentTimeMillis();
        Request requestPayload = this.formDataFactory.createAnalyzationPayload(file, metadata);
        this.loggerService.loggPayload(requestPayload, request.getRemoteAddr(), FormDataAnalyzationController.class);
        RiskProfile analyzationResult = this.analyzationService.analyze(requestPayload);
        long requestProcessingTime = System.currentTimeMillis() - requestRecivedTime;
        this.loggerService.loggAnalyzationResult(analyzationResult, requestPayload, request.getRemoteAddr(), requestProcessingTime, FormDataAnalyzationController.class);
        return analyzationResult;
    }
}

