/*
 * Decompiled with CFR 0.152.
 */
package no.nav.arxaas.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import no.nav.arxaas.model.Attribute;
import no.nav.arxaas.model.FormDataAttribute;
import no.nav.arxaas.model.FormMetaDataRequest;
import no.nav.arxaas.model.Request;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FormDataFactory {
    public Request createAnalyzationPayload(MultipartFile file, FormMetaDataRequest payload) {
        this.validateParameters(file, payload);
        List rawData = this.handleInputStream(file);
        List attributeList = this.buildRequestAnalyzationAttribute(payload.getAttributes());
        return new Request(rawData, attributeList, payload.getPrivacyModels(), payload.getSuppressionLimit());
    }

    public Request createAnonymizationPayload(MultipartFile file, FormMetaDataRequest payload, MultipartFile[] hierarchies) {
        this.validateParameters(file, payload);
        List rawData = this.handleInputStream(file);
        List attributeList = this.buildRequestAnonymizationAttribute(payload.getAttributes(), hierarchies);
        return new Request(rawData, attributeList, payload.getPrivacyModels(), payload.getSuppressionLimit());
    }

    private void validateParameters(MultipartFile file, FormMetaDataRequest payload) {
        if (file == null) {
            throw new IllegalArgumentException("file parameter is null");
        }
        if (payload == null) {
            throw new IllegalArgumentException("metadata payload parameter is null");
        }
    }

    private List<String[]> handleInputStream(MultipartFile file) {
        ArrayList<String[]> rawData = new ArrayList<String[]>();
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(file.getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                String[] data = line.split(";");
                rawData.add(data);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rawData;
    }

    private List<Attribute> buildRequestAnalyzationAttribute(List<FormDataAttribute> attributeList) {
        ArrayList<Attribute> newAttributeList = new ArrayList<Attribute>();
        attributeList.forEach(attribute -> {
            Attribute newAttribute = new Attribute(attribute.getField(), attribute.getAttributeTypeModel(), null);
            newAttributeList.add(newAttribute);
        });
        return newAttributeList;
    }

    private List<Attribute> buildRequestAnonymizationAttribute(List<FormDataAttribute> attributeList, MultipartFile[] hierarchies) {
        ArrayList<Attribute> newAttributeList = new ArrayList<Attribute>();
        attributeList.forEach(attribute -> {
            if (attribute.getHierarchy() != null && hierarchies.length > 1) {
                int hierarchyIndex = attribute.getHierarchy();
                List hierarchy = this.handleInputStream(hierarchies[hierarchyIndex]);
                Attribute newAttribute = new Attribute(attribute.getField(), attribute.getAttributeTypeModel(), hierarchy);
                newAttributeList.add(newAttribute);
            } else {
                Attribute newAttribute = new Attribute(attribute.getField(), attribute.getAttributeTypeModel(), null);
                newAttributeList.add(newAttribute);
            }
        });
        return newAttributeList;
    }
}

