/*
 * Decompiled with CFR 0.152.
 */
package no.nav.arxaas.analyzer;

import no.nav.arxaas.analyzer.Analyzer;
import no.nav.arxaas.model.Request;
import no.nav.arxaas.model.risk.AttributeRisk;
import no.nav.arxaas.model.risk.DistributionOfRisk;
import no.nav.arxaas.model.risk.ReIdentificationRisk;
import no.nav.arxaas.model.risk.RiskProfile;
import no.nav.arxaas.utils.DataFactory;
import org.deidentifier.arx.ARXPopulationModel;
import org.deidentifier.arx.Data;
import org.deidentifier.arx.DataHandle;
import org.deidentifier.arx.risk.RiskEstimateBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ARXAnalyzer
implements Analyzer {
    private final DataFactory dataFactory;

    @Autowired
    public ARXAnalyzer(DataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }

    public RiskProfile analyze(Request payload) {
        Data data = this.dataFactory.create(payload);
        DataHandle dataToAnalyse = data.getHandle();
        ARXPopulationModel pModel = ARXPopulationModel.create((int)data.getHandle().getNumRows(), (double)0.01);
        return new RiskProfile(this.reIdentificationRisk(dataToAnalyse, pModel), this.distributionOfRisk(dataToAnalyse, pModel), this.attributeRisk(dataToAnalyse, pModel));
    }

    private DistributionOfRisk distributionOfRisk(DataHandle dataToAnalyse, ARXPopulationModel pModel) {
        return DistributionOfRisk.create((RiskEstimateBuilder)dataToAnalyse.getRiskEstimator(pModel));
    }

    private ReIdentificationRisk reIdentificationRisk(DataHandle dataToAnalyse, ARXPopulationModel pModel) {
        return ReIdentificationRisk.create((DataHandle)dataToAnalyse, (ARXPopulationModel)pModel);
    }

    private AttributeRisk attributeRisk(DataHandle dataToAnalyse, ARXPopulationModel pModel) {
        return AttributeRisk.create((DataHandle)dataToAnalyse, (ARXPopulationModel)pModel);
    }
}

