/*
 * Decompiled with CFR 0.152.
 */
package no.nav.arxaas.controller;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import no.nav.arxaas.exception.UnableToReadInputStreamException;
import no.nav.arxaas.model.FormMetaDataRequest;
import no.nav.arxaas.model.Request;
import no.nav.arxaas.model.anonymity.AnonymizationResultPayload;
import no.nav.arxaas.service.AnonymizationService;
import no.nav.arxaas.service.LoggerService;
import no.nav.arxaas.utils.FormDataFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@CrossOrigin
@RestController
@RequestMapping(value={"/api/anonymize/file"})
public class FormDataAnonymizationController {
    private final AnonymizationService anonymizationService;
    private final LoggerService loggerService;
    private final FormDataFactory formDataFactory;

    @Autowired
    FormDataAnonymizationController(AnonymizationService anonymizationService, LoggerService loggerService, FormDataFactory formDataFactory) {
        this.anonymizationService = anonymizationService;
        this.loggerService = loggerService;
        this.formDataFactory = formDataFactory;
    }

    @PostMapping
    public AnonymizationResultPayload anonymization(@RequestPart(value="file") MultipartFile file, @RequestPart(value="metadata") @Valid FormMetaDataRequest payload, @RequestPart(value="hierarchies") MultipartFile[] hierarchies, HttpServletRequest request) {
        Request requestPayload;
        long requestRecivedTime = System.currentTimeMillis();
        try {
            requestPayload = this.formDataFactory.createAnonymizationPayload(file, payload, hierarchies);
        }
        catch (IOException e) {
            throw new UnableToReadInputStreamException(e.getMessage());
        }
        this.loggerService.loggPayload(requestPayload, request.getRemoteAddr(), FormDataAnonymizationController.class);
        AnonymizationResultPayload anonymizationResult = this.anonymizationService.anonymize(requestPayload);
        long requestProcessingTime = System.currentTimeMillis() - requestRecivedTime;
        this.loggerService.loggAnonymizeResult(anonymizationResult, requestProcessingTime, FormDataAnonymizationController.class, request.getRemoteAddr());
        return anonymizationResult;
    }
}

