/*
 * Decompiled with CFR 0.152.
 */
package no.nav.arxaas.model.risk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import no.nav.arxaas.model.risk.AttributeRisk;
import org.deidentifier.arx.ARXPopulationModel;
import org.deidentifier.arx.DataHandle;
import org.deidentifier.arx.risk.RiskModelAttributes;

public class AttributeRisk {
    private final List<QuasiIdentifierRisk> quasiIdentifierRiskList;

    @JsonCreator
    private AttributeRisk(@JsonProperty(value="quasiIdentifierRiskList") List<QuasiIdentifierRisk> quasiIdentifierRiskList) {
        this.quasiIdentifierRiskList = quasiIdentifierRiskList;
    }

    public List<QuasiIdentifierRisk> getQuasiIdentifierRiskList() {
        return this.quasiIdentifierRiskList;
    }

    public static AttributeRisk create(DataHandle dataToAnalyse, ARXPopulationModel pModel) {
        ArrayList<QuasiIdentifierRisk> quasiIdentifierRiskList = new ArrayList<QuasiIdentifierRisk>();
        for (String quasiAttribute : dataToAnalyse.getDefinition().getQuasiIdentifyingAttributes()) {
            RiskModelAttributes.QuasiIdentifierRisk[] data;
            for (RiskModelAttributes.QuasiIdentifierRisk quasiRisk : data = dataToAnalyse.getRiskEstimator(pModel, Set.of(quasiAttribute)).getAttributeRisks().getAttributeRisks()) {
                quasiIdentifierRiskList.add(new QuasiIdentifierRisk(quasiRisk.getIdentifier(), quasiRisk.getDistinction(), quasiRisk.getSeparation()));
            }
        }
        return new AttributeRisk(quasiIdentifierRiskList);
    }

    public String toString() {
        return "AttributeRisk{quasiIdentifierRiskList=" + this.quasiIdentifierRiskList + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeRisk that = (AttributeRisk)o;
        return Objects.equals(this.quasiIdentifierRiskList, that.quasiIdentifierRiskList);
    }

    public int hashCode() {
        return Objects.hash(this.quasiIdentifierRiskList);
    }
}

