/*
 * Decompiled with CFR 0.152.
 */
package no.nav.arxaas.utils;

import java.util.Map;
import no.nav.arxaas.exception.AaaSRuntimeException;
import no.nav.arxaas.model.anonymity.PrivacyCriterionModel;
import no.nav.arxaas.utils.ARXPrivacyCriterionFactory;
import org.deidentifier.arx.criteria.DistinctLDiversity;
import org.deidentifier.arx.criteria.EntropyLDiversity;
import org.deidentifier.arx.criteria.EqualDistanceTCloseness;
import org.deidentifier.arx.criteria.KAnonymity;
import org.deidentifier.arx.criteria.OrderedDistanceTCloseness;
import org.deidentifier.arx.criteria.PrivacyCriterion;
import org.deidentifier.arx.criteria.RecursiveCLDiversity;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ARXPrivacyCriterionFactory {
    private static final String COLUMNNAME = "column_name";

    PrivacyCriterion create(PrivacyCriterionModel.PrivacyModel model, Map<String, String> params) {
        switch (1.$SwitchMap$no$nav$arxaas$model$anonymity$PrivacyCriterionModel$PrivacyModel[model.ordinal()]) {
            case 1: {
                return new KAnonymity(Integer.parseInt(params.get("k")));
            }
            case 2: {
                ARXPrivacyCriterionFactory.validateColumnParam(params);
                return new DistinctLDiversity(params.get("column_name"), Integer.parseInt(params.get("l")));
            }
            case 3: {
                ARXPrivacyCriterionFactory.validateColumnParam(params);
                return new EntropyLDiversity(params.get("column_name"), (double)Integer.parseInt(params.get("l")), EntropyLDiversity.EntropyEstimator.SHANNON);
            }
            case 4: {
                ARXPrivacyCriterionFactory.validateColumnParam(params);
                return new EntropyLDiversity(params.get("column_name"), (double)Integer.parseInt(params.get("l")), EntropyLDiversity.EntropyEstimator.GRASSBERGER);
            }
            case 5: {
                ARXPrivacyCriterionFactory.validateColumnParam(params);
                return new RecursiveCLDiversity(params.get("column_name"), (double)Integer.parseInt(params.get("l")), Integer.parseInt(params.get("c")));
            }
            case 6: {
                ARXPrivacyCriterionFactory.validateColumnParam(params);
                return new OrderedDistanceTCloseness(params.get("column_name"), Double.parseDouble(params.get("t")));
            }
            case 7: {
                ARXPrivacyCriterionFactory.validateColumnParam(params);
                return new EqualDistanceTCloseness(params.get("column_name"), Double.parseDouble(params.get("t")));
            }
        }
        throw new AaaSRuntimeException(model.getName() + " Privacy Model not supported");
    }

    private static void validateColumnParam(Map<String, String> lDivParams) {
        if (!lDivParams.containsKey("column_name") || lDivParams.get("column_name").isEmpty()) {
            throw new IllegalArgumentException("Privacy Model must contain column_name param");
        }
    }
}

