/*
 * Decompiled with CFR 0.152.
 */
package no.nav.arxaas.utils;

import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import no.nav.arxaas.model.Attribute;
import no.nav.arxaas.model.FormDataAttribute;
import no.nav.arxaas.model.FormMetaDataRequest;
import no.nav.arxaas.model.Request;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FormDataFactory {
    public Request createAnalyzationPayload(MultipartFile file, FormMetaDataRequest payload) throws IOException {
        this.validateParameters(file, payload);
        List rawData = this.handleInputStream(file);
        List attributeList = this.buildRequestAnalyzationAttribute(payload.getAttributes());
        return new Request(rawData, attributeList, payload.getPrivacyModels(), payload.getSuppressionLimit());
    }

    public Request createAnonymizationPayload(MultipartFile file, FormMetaDataRequest payload, MultipartFile[] hierarchies) throws IOException {
        this.validateParameters(file, payload);
        List rawData = this.handleInputStream(file);
        List hierarchiesContent = new ArrayList();
        if (hierarchies.length > 0) {
            hierarchiesContent = this.handleHierarchiesInputStream(hierarchies);
        }
        List attributeList = this.buildRequestAnonymizationAttribute(payload.getAttributes(), hierarchiesContent);
        return new Request(rawData, attributeList, payload.getPrivacyModels(), payload.getSuppressionLimit());
    }

    private void validateParameters(MultipartFile file, FormMetaDataRequest payload) {
        if (file == null) {
            throw new IllegalArgumentException("file parameter is null");
        }
        if (payload == null) {
            throw new IllegalArgumentException("metadata payload parameter is null");
        }
    }

    private List<String[]> handleInputStream(MultipartFile file) throws IOException {
        CsvParserSettings settings = new CsvParserSettings();
        settings.setDelimiterDetectionEnabled(true, new char[]{';', ','});
        CsvParser parser = new CsvParser(settings);
        try (InputStream fileContent = file.getInputStream();){
            List list = parser.parseAll(fileContent);
            return list;
        }
    }

    private List<Attribute> buildRequestAnalyzationAttribute(List<FormDataAttribute> attributeList) {
        ArrayList<Attribute> newAttributeList = new ArrayList<Attribute>();
        attributeList.forEach(attribute -> {
            Attribute newAttribute = new Attribute(attribute.getField(), attribute.getAttributeTypeModel(), null);
            newAttributeList.add(newAttribute);
        });
        return newAttributeList;
    }

    private List<Attribute> buildRequestAnonymizationAttribute(List<FormDataAttribute> attributeList, List<List<String[]>> hierarchies) {
        ArrayList<Attribute> newAttributeList = new ArrayList<Attribute>();
        attributeList.forEach(attribute -> {
            if (attribute.getHierarchy() != null && hierarchies.size() > 0) {
                int hierarchyIndex = attribute.getHierarchy();
                List hierarchy = (List)hierarchies.get(hierarchyIndex);
                Attribute newAttribute = new Attribute(attribute.getField(), attribute.getAttributeTypeModel(), hierarchy);
                newAttributeList.add(newAttribute);
            } else {
                Attribute newAttribute = new Attribute(attribute.getField(), attribute.getAttributeTypeModel(), null);
                newAttributeList.add(newAttribute);
            }
        });
        return newAttributeList;
    }

    private List<List<String[]>> handleHierarchiesInputStream(MultipartFile[] hierarchies) throws IOException {
        ArrayList<List<String[]>> hierarchiesContent = new ArrayList<List<String[]>>();
        for (int x = 0; x < hierarchies.length; ++x) {
            List hierarchyContent = this.handleInputStream(hierarchies[x]);
            hierarchiesContent.add(x, hierarchyContent);
        }
        return hierarchiesContent;
    }
}

