/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.security.veilarbabac;

import java.util.Optional;
import java.util.function.Supplier;
import no.nav.apiapp.security.veilarbabac.MetrikkLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TilgangssjekkEnhet {
    private static final Logger logger = LoggerFactory.getLogger(TilgangssjekkEnhet.class);
    private Supplier<Boolean> veilarbAbacSjekker;
    private Supplier<Boolean> abacSjekker;
    private MetrikkLogger metrikk = new MetrikkLogger(logger, "read", () -> "");
    private Boolean foretrekkVeilarbAbac = false;
    private Boolean sammenliknTilgang = false;

    TilgangssjekkEnhet() {
    }

    TilgangssjekkEnhet metrikkLogger(Logger logger, String action, Supplier<String> idSupplier) {
        this.metrikk = new MetrikkLogger(logger, action, idSupplier);
        return this;
    }

    TilgangssjekkEnhet veilarbAbacSjekker(Supplier<Boolean> veilarbAbacSjekker) {
        this.veilarbAbacSjekker = veilarbAbacSjekker;
        return this;
    }

    TilgangssjekkEnhet abacSjekker(Supplier<Boolean> abacSjekker) {
        this.abacSjekker = abacSjekker;
        return this;
    }

    TilgangssjekkEnhet foretrekkVeilarbAbac(boolean foretrekkVeilarbAbac) {
        this.foretrekkVeilarbAbac = foretrekkVeilarbAbac;
        return this;
    }

    TilgangssjekkEnhet sammenliknTilgang(boolean sammenlikntilgang) {
        this.sammenliknTilgang = sammenlikntilgang;
        return this;
    }

    boolean sjekkTilgangTilEnhet() {
        boolean harTilgang = this.sammenliknTilgang != false ? this.sjekkOgSammenliknTilgang() : this.sjekkTilgang().booleanValue();
        this.metrikk.loggMetrikk(MetrikkLogger.Tilgangstype.Enhet, this.foretrekkVeilarbAbac);
        return harTilgang;
    }

    private Boolean sjekkTilgang() {
        Optional<Boolean> veilarbAbacResultat = Optional.empty();
        if (this.foretrekkVeilarbAbac.booleanValue()) {
            veilarbAbacResultat = this.tryggSjekkTilgangVeilarbAbac();
        }
        return veilarbAbacResultat.orElseGet(() -> this.abacSjekker.get());
    }

    private boolean sjekkOgSammenliknTilgang() {
        Optional<Boolean> veilarbAbacResultat = this.tryggSjekkTilgangVeilarbAbac();
        boolean abacResultat = this.abacSjekker.get();
        if (veilarbAbacResultat.isPresent() && abacResultat != veilarbAbacResultat.get()) {
            this.metrikk.erAvvik();
        }
        if (this.foretrekkVeilarbAbac.booleanValue() && veilarbAbacResultat.isPresent()) {
            return veilarbAbacResultat.get();
        }
        return abacResultat;
    }

    private Optional<Boolean> tryggSjekkTilgangVeilarbAbac() {
        Boolean veilarbAbacResultat = null;
        try {
            veilarbAbacResultat = this.veilarbAbacSjekker.get();
        }
        catch (Throwable e) {
            logger.error("Kall mot veilarbAbac feiler", e);
        }
        return Optional.ofNullable(veilarbAbacResultat);
    }
}

