/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.servlet;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterBuilder {
    private static final Logger log = LoggerFactory.getLogger(FilterBuilder.class);
    private static AtomicInteger counter = new AtomicInteger();
    private final Class<? extends Filter> filterClass;
    private Filter filter;
    private EnumSet<DispatcherType> dispatcherTypes = EnumSet.of(DispatcherType.REQUEST);
    private String[] urlPatterns = new String[]{"/*"};
    private Map<String, String> initParameters = new HashMap<String, String>();

    public FilterBuilder(Class<? extends Filter> filterClass) {
        this.filterClass = filterClass;
    }

    public FilterBuilder(Filter filter) {
        this.filterClass = filter.getClass();
        this.filter = filter;
    }

    public FilterBuilder dispatcherTypes(DispatcherType ... dispatcherType) {
        this.dispatcherTypes = EnumSet.copyOf(Arrays.asList(dispatcherType));
        return this;
    }

    public FilterBuilder urlPatterns(String ... urlPatterns) {
        this.urlPatterns = urlPatterns;
        return this;
    }

    public FilterBuilder initParameter(String name, String value) {
        this.initParameters.put(name, value);
        return this;
    }

    public FilterRegistration.Dynamic register(ServletContextEvent servletContextEvent) {
        return this.register(servletContextEvent.getServletContext());
    }

    public FilterRegistration.Dynamic register(ServletContext servletContext) {
        String filterClassName = this.filterClass.getName();
        log.info("adding filter {} on {} for {}", new Object[]{filterClassName, this.urlPatterns, this.dispatcherTypes});
        String filterName = filterClassName + "_" + counter.incrementAndGet();
        FilterRegistration.Dynamic dynamic = this.filter != null ? servletContext.addFilter(filterName, this.filter) : servletContext.addFilter(filterName, this.filterClass);
        dynamic.addMappingForUrlPatterns(this.dispatcherTypes, false, this.urlPatterns);
        this.initParameters.forEach((arg_0, arg_1) -> ((FilterRegistration.Dynamic)dynamic).setInitParameter(arg_0, arg_1));
        return dynamic;
    }
}

