/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.util;

import java.io.File;
import java.util.Optional;
import no.nav.apiapp.ApiApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarFolderFinderUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(WarFolderFinderUtil.class);

    public static File findPath(Class<? extends ApiApplication> apiAppClass) {
        Optional<File> sourcesPath = WarFolderFinderUtil.locateSourcesPath(apiAppClass);
        if (WarFolderFinderUtil.isRunningLocally(sourcesPath)) {
            return WarFolderFinderUtil.addWebAppFolder(sourcesPath.get());
        }
        LOGGER.debug("Falling back to use the default Docker war folder");
        return new File("/app");
    }

    private static Optional<File> locateSourcesPath(Class<? extends ApiApplication> apiAppClass) {
        Optional<File> baseDir = WarFolderFinderUtil.locateBaseDir(apiAppClass);
        if (baseDir.isPresent()) {
            File sourcesPath = new File(baseDir.get(), "src/main");
            return Optional.of(sourcesPath);
        }
        return Optional.empty();
    }

    private static Optional<File> locateBaseDir(Class<? extends ApiApplication> apiAppClass) {
        try {
            File classesDir = new File(apiAppClass.getResource("/").toURI());
            File baseDir = new File(classesDir, "../../").getCanonicalFile();
            return Optional.of(baseDir);
        }
        catch (Exception e) {
            LOGGER.warn("Sources path not found.", (Throwable)e);
            return Optional.empty();
        }
    }

    private static boolean isRunningLocally(Optional<File> sourcesPath) {
        return sourcesPath.isPresent() && sourcesPath.get().exists();
    }

    private static File addWebAppFolder(File sourcesPath) {
        File webAppPath = new File(sourcesPath, "webapp");
        webAppPath.mkdir();
        return webAppPath;
    }
}

