/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.security;

import javax.servlet.http.HttpServletRequest;
import no.nav.brukerdialog.security.oidc.OidcTokenUtils;
import no.nav.common.auth.AuthorizationModule;
import no.nav.common.auth.SsoToken;
import no.nav.common.auth.Subject;
import no.nav.common.auth.openam.sbs.OpenAmUtils;

public class SecurityLevelAuthorizationModule
implements AuthorizationModule {
    private final int minimumLevel;

    public SecurityLevelAuthorizationModule(int minimumLevel) {
        this.minimumLevel = minimumLevel;
    }

    public boolean authorized(Subject subject, HttpServletRequest httpServletRequest) {
        return subject != null && this.getSecurityLevel(subject) >= this.minimumLevel;
    }

    private int getSecurityLevel(Subject subject) {
        SsoToken ssoToken = subject.getSsoToken();
        switch (ssoToken.getType()) {
            case OIDC: {
                return OidcTokenUtils.getOidcSecurityLevel((SsoToken)ssoToken).getSecurityLevel();
            }
            case EKSTERN_OPENAM: {
                return OpenAmUtils.getSecurityLevel((SsoToken)ssoToken).getSecurityLevel();
            }
        }
        return Integer.MIN_VALUE;
    }
}

