/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.security.veilarbabac;

import java.util.function.Supplier;
import no.nav.apiapp.feil.IngenTilgang;
import no.nav.apiapp.security.veilarbabac.MetrikkLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TilgangssjekkBruker {
    private static final Logger logger = LoggerFactory.getLogger(TilgangssjekkBruker.class);
    private MetrikkLogger metrikk = new MetrikkLogger(logger, "read", () -> "");
    private Supplier<Boolean> veilarbabacFnrSjekker;
    private Supplier<Boolean> veilarbabacAktoerIdSjekker;
    private Runnable abacFnrSjekker = () -> {};
    private Boolean brukAktoerId = false;
    private Boolean sammenliknTilgang = false;
    private Boolean foretrekkVeilarbAbac = false;

    TilgangssjekkBruker() {
    }

    TilgangssjekkBruker metrikkLogger(Logger logger, String action, Supplier<String> idSupplier) {
        this.metrikk = new MetrikkLogger(logger, action, idSupplier);
        return this;
    }

    TilgangssjekkBruker veilarbAbacFnrSjekker(Supplier<Boolean> veilarbabacFnrSjekker) {
        this.veilarbabacFnrSjekker = veilarbabacFnrSjekker;
        return this;
    }

    TilgangssjekkBruker veilarbAbacAktoerIdSjekker(Supplier<Boolean> veilarbabacAktoerIdSjekker) {
        this.veilarbabacAktoerIdSjekker = veilarbabacAktoerIdSjekker;
        return this;
    }

    TilgangssjekkBruker abacFnrSjekker(Runnable abacFnrSjekker) {
        this.abacFnrSjekker = abacFnrSjekker;
        return this;
    }

    TilgangssjekkBruker foretrekkVeilarbAbac(boolean foretrekkVeilarbAbac) {
        this.foretrekkVeilarbAbac = foretrekkVeilarbAbac;
        return this;
    }

    TilgangssjekkBruker sammenliknTilgang(boolean sammenlikntilgang) {
        this.sammenliknTilgang = sammenlikntilgang;
        return this;
    }

    TilgangssjekkBruker brukAktoerId(boolean brukAktoerId) {
        this.brukAktoerId = brukAktoerId;
        return this;
    }

    void sjekkTilgangTilBruker() {
        boolean harTilgang = this.brukAktoerId != false && this.sammenliknTilgang != false ? this.sjekkOgSammenliknTilgangForAktoerIdOgFnr() : (this.sammenliknTilgang != false ? this.sjekkOgSammenliknTilgangForFnr() : (this.brukAktoerId != false ? this.sjekkTilgangTilAktoerId() : this.sjekkAbacTilgangTilFnr()));
        this.metrikk.loggMetrikk(this.brukAktoerId != false ? MetrikkLogger.Tilgangstype.PersonAktoerId : MetrikkLogger.Tilgangstype.PersonFoedselsnummer, this.foretrekkVeilarbAbac);
        if (!harTilgang) {
            throw new IngenTilgang();
        }
    }

    private boolean sjekkTilgangTilAktoerId() {
        return this.veilarbabacAktoerIdSjekker.get();
    }

    private boolean sjekkOgSammenliknTilgangForFnr() {
        Boolean veilarbAbacResultat = null;
        try {
            veilarbAbacResultat = this.veilarbabacFnrSjekker.get();
        }
        catch (Throwable e) {
            logger.error("Kall mot veilarbAbac feiler", e);
        }
        boolean abacResultat = this.sjekkAbacTilgangTilFnr();
        if (veilarbAbacResultat != null && abacResultat != veilarbAbacResultat) {
            this.metrikk.erAvvik();
        }
        if (veilarbAbacResultat != null && this.foretrekkVeilarbAbac.booleanValue()) {
            return veilarbAbacResultat;
        }
        return abacResultat;
    }

    private boolean sjekkOgSammenliknTilgangForAktoerIdOgFnr() {
        boolean aktoerIdResultat;
        boolean fnrResultat = this.veilarbabacFnrSjekker.get();
        if (fnrResultat != (aktoerIdResultat = this.veilarbabacAktoerIdSjekker.get().booleanValue())) {
            this.metrikk.erAvvik();
        }
        return fnrResultat;
    }

    private boolean sjekkAbacTilgangTilFnr() {
        try {
            this.abacFnrSjekker.run();
            return true;
        }
        catch (IngenTilgang e) {
            return false;
        }
    }
}

