/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.soap;

import java.lang.reflect.Method;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.soap.SOAPFaultException;
import no.nav.apiapp.feil.FeilDTO;
import no.nav.apiapp.feil.FeilMapper;
import no.nav.apiapp.util.StringUtils;
import no.nav.json.JsonUtils;
import no.nav.metrics.MetodeTimer;
import org.apache.cxf.jaxws.JAXWSMethodInvoker;
import org.apache.cxf.message.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodInvokerMedFeilhandtering
extends JAXWSMethodInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodInvokerMedFeilhandtering.class);
    private final SOAPFactory soapFactory;

    public MethodInvokerMedFeilhandtering(Object serviceBean) {
        super(serviceBean);
        try {
            this.soapFactory = SOAPFactory.newInstance();
        }
        catch (SOAPException e) {
            throw new RuntimeException(e);
        }
    }

    protected SOAPFaultException findSoapFaultException(Throwable throwable) {
        FeilDTO feilDTO = FeilMapper.somFeilDTO(throwable);
        try {
            SOAPFault fault = this.soapFactory.createFault();
            fault.setFaultString(feilDTO.id);
            fault.setFaultCode(feilDTO.type);
            String detaljerJson = JsonUtils.toJson((Object)feilDTO.detaljer);
            if (StringUtils.notNullOrEmpty(detaljerJson)) {
                fault.addDetail().addTextNode(detaljerJson);
            }
            return new SOAPFaultException(fault);
        }
        catch (SOAPException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return super.findSoapFaultException(throwable);
        }
    }

    protected Object performInvocation(Exchange exchange, Object serviceObject, Method m, Object[] paramArray) throws Exception {
        return MetodeTimer.timeMetode(() -> super.performInvocation(exchange, serviceObject, m, paramArray), (String)("ws." + m.getName()));
    }
}

