/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.security;

import java.util.Optional;
import no.nav.apiapp.feil.IngenTilgang;
import no.nav.sbl.dialogarena.common.abac.pep.Pep;
import no.nav.sbl.dialogarena.common.abac.pep.domain.ResourceType;
import no.nav.sbl.dialogarena.common.abac.pep.domain.request.Action;
import no.nav.sbl.dialogarena.common.abac.pep.domain.response.BiasedDecisionResponse;
import no.nav.sbl.dialogarena.common.abac.pep.domain.response.Decision;
import no.nav.sbl.dialogarena.common.abac.pep.exception.PepException;

public class PepClient {
    private final Pep pep;
    private final String applicationDomain;
    private final ResourceType resourceType;

    @Deprecated
    public PepClient(Pep pep, String applicationDomain) {
        this(pep, applicationDomain, ResourceType.Person);
    }

    public PepClient(Pep pep, String applicationDomain, ResourceType resourceType) {
        this.pep = pep;
        this.applicationDomain = applicationDomain;
        this.resourceType = resourceType;
    }

    @Deprecated
    public String sjekkTilgangTilFnr(String fnr) {
        return this.sjekkLeseTilgangTilFnr(fnr);
    }

    public String sjekkLeseTilgangTilFnr(String fnr) {
        return this.sjekkTilgang(fnr, Action.ActionId.READ);
    }

    public String sjekkSkriveTilgangTilFnr(String fnr) {
        return this.sjekkTilgang(fnr, Action.ActionId.WRITE);
    }

    public void sjekkTilgangTilEnhet(String enhet) throws IngenTilgang, PepException {
        if (!this.harTilgangTilEnhet(enhet)) {
            throw new IngenTilgang(String.format("Ingen tilgang til enhet '%s'", enhet));
        }
    }

    public boolean harTilgangTilEnhet(String enhet) throws PepException {
        BiasedDecisionResponse r = this.pep.harTilgang(this.pep.nyRequest().withResourceType(ResourceType.Enhet).withDomain(this.applicationDomain).withEnhet(Optional.ofNullable(enhet).orElse("")));
        return this.erPermit(r);
    }

    private String sjekkTilgang(String fnr, Action.ActionId action) throws PepException {
        if (this.erPermit(this.pep.harInnloggetBrukerTilgangTilPerson(fnr, this.applicationDomain, action, this.resourceType))) {
            return fnr;
        }
        throw new IngenTilgang();
    }

    private boolean erPermit(BiasedDecisionResponse biasedDecisionResponse) {
        return Optional.ofNullable(biasedDecisionResponse).map(BiasedDecisionResponse::getBiasedDecision).map(d -> d == Decision.Permit).orElse(false);
    }
}

