/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.servlet.Filter;
import no.nav.apiapp.ApiApplication;
import no.nav.apiapp.config.ApiAppConfigurator;
import no.nav.apiapp.config.IssoConfig;
import no.nav.apiapp.config.StsConfig;
import no.nav.apiapp.selftest.impl.OpenAMHelsesjekk;
import no.nav.apiapp.util.UrlUtils;
import no.nav.brukerdialog.security.Constants;
import no.nav.brukerdialog.security.jaspic.OidcAuthModule;
import no.nav.brukerdialog.security.oidc.SystemUserTokenProvider;
import no.nav.brukerdialog.security.oidc.SystemUserTokenProviderConfig;
import no.nav.brukerdialog.security.oidc.provider.AzureADB2CConfig;
import no.nav.brukerdialog.security.oidc.provider.AzureADB2CProvider;
import no.nav.brukerdialog.security.oidc.provider.IssoOidcProvider;
import no.nav.brukerdialog.security.oidc.provider.IssoOidcProviderConfig;
import no.nav.brukerdialog.security.oidc.provider.OidcProvider;
import no.nav.brukerdialog.security.oidc.provider.SecurityTokenServiceOidcProvider;
import no.nav.brukerdialog.security.oidc.provider.SecurityTokenServiceOidcProviderConfig;
import no.nav.brukerdialog.security.pingable.IssoIsAliveHelsesjekk;
import no.nav.brukerdialog.security.pingable.IssoSystemBrukerTokenHelsesjekk;
import no.nav.common.auth.AuthorizationModule;
import no.nav.common.auth.LoginFilter;
import no.nav.common.auth.LoginProvider;
import no.nav.common.auth.openam.sbs.OpenAMLoginFilter;
import no.nav.common.auth.openam.sbs.OpenAmConfig;
import no.nav.json.JsonProvider;
import no.nav.sbl.dialogarena.common.jetty.Jetty;
import no.nav.sbl.dialogarena.types.Pingable;
import no.nav.sbl.util.EnvironmentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Konfigurator
implements ApiAppConfigurator {
    private static final Logger log = LoggerFactory.getLogger(Konfigurator.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(Konfigurator.class);
    private final Jetty.JettyBuilder jettyBuilder;
    private final List<OidcProvider> oidcProviders = new ArrayList<OidcProvider>();
    private final List<LoginProvider> loginProviders = new ArrayList<LoginProvider>();
    private final List<Consumer<Jetty>> jettyCustomizers = new ArrayList<Consumer<Jetty>>();
    private final List<Consumer<Jetty.JettyBuilder>> jettyBuilderCustomizers = new ArrayList<Consumer<Jetty.JettyBuilder>>();
    private final List<String> publicPaths = new ArrayList<String>();
    private final List<Object> springBonner = new ArrayList<Object>();
    private final List<Pingable> pingables = new ArrayList<Pingable>();
    private AuthorizationModule authorizationModule;
    private ObjectMapper objectMapper = JsonProvider.createObjectMapper();

    public Konfigurator(Jetty.JettyBuilder jettyBuilder, ApiApplication apiApplication) {
        this.jettyBuilder = jettyBuilder;
        String apiBasePath = apiApplication.getApiBasePath();
        this.addPublicPath("/internal/.*").addPublicPath("/ws/.*").addPublicPath(UrlUtils.joinPaths(apiBasePath, "/ping")).addPublicPath(UrlUtils.joinPaths(apiBasePath, "swagger.json"));
    }

    @Override
    public ApiAppConfigurator sts() {
        return this.sts(this.defaultStsConfig());
    }

    StsConfig defaultStsConfig() {
        return StsConfig.builder().url(this.getConfigProperty("no.nav.modig.security.sts.url", "SECURITYTOKENSERVICE_URL")).username(this.getConfigProperty("no.nav.modig.security.systemuser.username", EnvironmentUtils.resolveSrvUserPropertyName())).password(this.getConfigProperty("no.nav.modig.security.systemuser.password", EnvironmentUtils.resolverSrvPasswordPropertyName())).build();
    }

    @Override
    public ApiAppConfigurator sts(StsConfig stsConfig) {
        EnvironmentUtils.setProperty((String)"no.nav.modig.security.sts.url", (String)stsConfig.url, (EnvironmentUtils.Type)EnvironmentUtils.Type.PUBLIC);
        EnvironmentUtils.setProperty((String)"no.nav.modig.security.systemuser.username", (String)stsConfig.username, (EnvironmentUtils.Type)EnvironmentUtils.Type.PUBLIC);
        EnvironmentUtils.setProperty((String)"no.nav.modig.security.systemuser.password", (String)stsConfig.password, (EnvironmentUtils.Type)EnvironmentUtils.Type.SECRET);
        return this;
    }

    @Override
    public ApiAppConfigurator openAmLogin() {
        return this.openAmLogin(OpenAmConfig.fromSystemProperties());
    }

    @Override
    public ApiAppConfigurator openAmLogin(OpenAmConfig openAmConfig) {
        this.loginProviders.add((LoginProvider)new OpenAMLoginFilter(openAmConfig));
        this.springBonner.add(new OpenAMHelsesjekk(openAmConfig));
        return this;
    }

    @Override
    public ApiAppConfigurator issoLogin() {
        return this.issoLogin(IssoConfig.builder().username(this.getConfigProperty("no.nav.modig.security.systemuser.username", EnvironmentUtils.resolveSrvUserPropertyName())).password(this.getConfigProperty("no.nav.modig.security.systemuser.password", EnvironmentUtils.resolverSrvPasswordPropertyName())).issoHostUrl(Constants.getIssoHostUrl()).issoRpUserUsername(Constants.getIssoRpUserUsername()).issoRpUserPassword(Constants.getIssoRpUserPassword()).issoJwksUrl(Constants.getIssoJwksUrl()).issoExpectedTokenIssuer(Constants.getIssoExpectedTokenIssuer()).oidcRedirectUrl(Constants.getOidcRedirectUrl()).isAliveUrl(Constants.getIssoIsaliveUrl()).build());
    }

    @Override
    public ApiAppConfigurator issoLogin(IssoConfig issoConfig) {
        SystemUserTokenProviderConfig systemUserTokenProviderConfig = SystemUserTokenProviderConfig.builder().srvUsername(issoConfig.username).srvPassword(issoConfig.password).issoHostUrl(issoConfig.issoHostUrl).issoRpUserUsername(issoConfig.issoRpUserUsername).issoRpUserPassword(issoConfig.issoRpUserPassword).issoJwksUrl(issoConfig.issoJwksUrl).issoExpectedTokenIssuer(issoConfig.issoExpectedTokenIssuer).oidcRedirectUrl(issoConfig.oidcRedirectUrl).build();
        SystemUserTokenProvider systemUserTokenProvider = new SystemUserTokenProvider(systemUserTokenProviderConfig);
        this.springBonner.add(systemUserTokenProvider);
        this.springBonner.add(new IssoSystemBrukerTokenHelsesjekk(systemUserTokenProvider));
        this.springBonner.add(new IssoIsAliveHelsesjekk(issoConfig.isAliveUrl));
        return this.oidcProvider((OidcProvider)new IssoOidcProvider(IssoOidcProviderConfig.from((SystemUserTokenProviderConfig)systemUserTokenProviderConfig)));
    }

    @Override
    @Deprecated
    public ApiAppConfigurator azureADB2CLogin() {
        return this.azureADB2CLogin(AzureADB2CConfig.configureAzureAdForExternalUsers());
    }

    @Override
    @Deprecated
    public ApiAppConfigurator azureADB2CLogin(AzureADB2CConfig azureADB2CConfig) {
        return this.oidcProvider((OidcProvider)new AzureADB2CProvider(azureADB2CConfig));
    }

    @Override
    public ApiAppConfigurator validateAzureAdExternalUserTokens() {
        return this.oidcProvider((OidcProvider)new AzureADB2CProvider(AzureADB2CConfig.configureAzureAdForExternalUsers()));
    }

    @Override
    public ApiAppConfigurator validateAzureAdInternalUsersTokens() {
        return this.oidcProvider((OidcProvider)new AzureADB2CProvider(AzureADB2CConfig.configureAzureAdForInternalUsers()));
    }

    @Override
    public ApiAppConfigurator securityTokenServiceLogin() {
        return this.securityTokenServiceLogin(SecurityTokenServiceOidcProviderConfig.readFromSystemProperties());
    }

    @Override
    public ApiAppConfigurator securityTokenServiceLogin(SecurityTokenServiceOidcProviderConfig securityTokenServiceOidcProviderConfig) {
        return this.oidcProvider((OidcProvider)new SecurityTokenServiceOidcProvider(securityTokenServiceOidcProviderConfig));
    }

    @Override
    public ApiAppConfigurator oidcProvider(OidcProvider oidcProvider) {
        this.oidcProviders.add(oidcProvider);
        this.springBonner.add(oidcProvider);
        return this;
    }

    @Override
    public ApiAppConfigurator addPublicPath(String path) {
        this.publicPaths.add(path);
        return this;
    }

    @Override
    public ApiAppConfigurator authorizationModule(AuthorizationModule authorizationModule) {
        this.authorizationModule = authorizationModule;
        return this;
    }

    @Override
    public ApiAppConfigurator customizeJetty(Consumer<Jetty> jettyCustomizer) {
        this.jettyCustomizers.add(jettyCustomizer);
        return this;
    }

    @Override
    public ApiAppConfigurator customizeJettyBuilder(Consumer<Jetty.JettyBuilder> jettyBuilderCustomizer) {
        this.jettyBuilderCustomizers.add(jettyBuilderCustomizer);
        return this;
    }

    @Override
    public ApiAppConfigurator selfTest(Pingable pingable) {
        return this.selfTests(Collections.singletonList(pingable));
    }

    @Override
    public ApiAppConfigurator selfTests(Pingable ... pingables) {
        return this.selfTests(Arrays.asList(pingables));
    }

    @Override
    public ApiAppConfigurator selfTests(Collection<? extends Pingable> pingables) {
        this.pingables.addAll(pingables);
        return this;
    }

    @Override
    public ApiAppConfigurator objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    private String getConfigProperty(String primaryProperty, String secondaryProperty) {
        LOGGER.info("reading config-property {} / {}", (Object)primaryProperty, (Object)secondaryProperty);
        return EnvironmentUtils.getOptionalProperty((String)primaryProperty, (String[])new String[0]).orElseGet(() -> EnvironmentUtils.getRequiredProperty((String)secondaryProperty, (String[])new String[0]));
    }

    public Jetty buildJetty() {
        if (!this.oidcProviders.isEmpty()) {
            this.loginProviders.add((LoginProvider)new OidcAuthModule(this.oidcProviders));
        }
        if (this.hasLogin()) {
            log.info("adding {} with loginProviders={} authorizationModule={} publicPaths={}", new Object[]{LoginFilter.class.getSimpleName(), this.loginProviders, this.authorizationModule, this.publicPaths});
            this.jettyBuilder.addFilter((Filter)new LoginFilter(this.loginProviders, this.authorizationModule, this.publicPaths));
        }
        this.jettyBuilderCustomizers.forEach(c -> c.accept(this.jettyBuilder));
        Jetty jetty = this.jettyBuilder.buildJetty();
        this.jettyCustomizers.forEach(c -> c.accept(jetty));
        return jetty;
    }

    public boolean hasLogin() {
        return !this.oidcProviders.isEmpty() || !this.loginProviders.isEmpty() || this.authorizationModule != null;
    }

    public List<Object> getSpringBonner() {
        return this.springBonner;
    }

    public List<Pingable> getPingables() {
        return this.pingables;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

