/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.selftest.impl;

import java.util.stream.Stream;
import javax.xml.namespace.QName;
import no.nav.apiapp.selftest.Helsesjekk;
import no.nav.apiapp.selftest.HelsesjekkMetadata;
import no.nav.sbl.dialogarena.common.cxf.STSConfigurationUtil;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.ServiceImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyContainingAssertion;
import org.apache.neethi.PolicyOperator;
import org.apache.wss4j.policy.model.IssuedToken;
import org.w3c.dom.Element;

public class STSHelsesjekk
implements Helsesjekk {
    @Override
    public void helsesjekk() throws Exception {
        new Sjekk().sjekk();
    }

    @Override
    public HelsesjekkMetadata getMetadata() {
        return new HelsesjekkMetadata("sts", System.getProperty("no.nav.modig.security.sts.url"), "Sjekker at systembruker kan hente token fra STS", true);
    }

    private Stream<PolicyComponent> findAll(PolicyComponent policyComponent) {
        return Stream.concat(Stream.of(policyComponent), this.findSubComponents(policyComponent));
    }

    private Stream<PolicyComponent> findSubComponents(PolicyComponent policyComponent) {
        if (policyComponent instanceof PolicyOperator) {
            return ((PolicyOperator)policyComponent).getPolicyComponents().stream().flatMap(this::findAll);
        }
        if (policyComponent instanceof PolicyContainingAssertion) {
            return this.findAll((PolicyComponent)((PolicyContainingAssertion)policyComponent).getPolicy());
        }
        return Stream.empty();
    }

    private class Sjekk {
        private Bus bus = BusFactory.getDefaultBus();
        private PolicyEngine policyEngine = (PolicyEngine)this.bus.getExtension(PolicyEngine.class);
        private EndpointInfo endpointInfo = this.dummyEndpointInfo();
        private ClientImpl client = this.dummyClient();
        private MessageImpl message = this.dummyMessage();
        private STSClient stsClient = this.stsClient();

        private Sjekk() {
        }

        private void sjekk() throws Exception {
            this.stsClient.requestSecurityToken();
        }

        private ClientImpl dummyClient() {
            ServiceImpl service = new ServiceImpl();
            return new ClientImpl(this.bus, (Endpoint)new EndpointImpl(this.bus, (Service)service, this.endpointInfo));
        }

        private EndpointInfo dummyEndpointInfo() {
            ServiceInfo serv = new ServiceInfo();
            serv.setInterface(new InterfaceInfo(serv, null));
            EndpointInfo endpointInfo = new EndpointInfo(serv, (String)HTTPTransportFactory.DEFAULT_NAMESPACES.get(0));
            endpointInfo.setName(new QName("dummy"));
            return endpointInfo;
        }

        private MessageImpl dummyMessage() {
            MessageImpl message = new MessageImpl();
            ExchangeImpl exchange = new ExchangeImpl();
            exchange.put(Bus.class, (Object)this.bus);
            message.setExchange((Exchange)exchange);
            return message;
        }

        private STSClient stsClient() {
            STSConfigurationUtil.configureStsForSystemUserInFSS((Client)this.client);
            STSClient stsClient = (STSClient)this.client.getRequestContext().values().iterator().next();
            stsClient.setMessage((Message)this.message);
            stsClient.setTemplate(this.getRequestSecurityTokenTemplate());
            return stsClient;
        }

        private Element getRequestSecurityTokenTemplate() {
            EndpointPolicy clientEndpointPolicy = this.policyEngine.getClientEndpointPolicy(this.endpointInfo, this.client.getConduit(), null);
            return STSHelsesjekk.this.findAll((PolicyComponent)clientEndpointPolicy.getPolicy()).filter(IssuedToken.class::isInstance).map(IssuedToken.class::cast).map(IssuedToken::getRequestSecurityTokenTemplate).findAny().orElseThrow(IllegalStateException::new);
        }
    }
}

