/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.security.veilarbabac;

import java.util.Optional;
import java.util.function.Supplier;
import javax.ws.rs.client.WebTarget;
import no.nav.apiapp.security.PepClient;
import no.nav.apiapp.security.veilarbabac.Bruker;
import no.nav.apiapp.security.veilarbabac.TilgangssjekkBruker;
import no.nav.apiapp.security.veilarbabac.TilgangssjekkEnhet;
import no.nav.apiapp.selftest.Helsesjekk;
import no.nav.apiapp.selftest.HelsesjekkMetadata;
import no.nav.apiapp.util.UrlUtils;
import no.nav.common.auth.SsoToken;
import no.nav.common.auth.SubjectHandler;
import no.nav.sbl.dialogarena.common.abac.pep.Pep;
import no.nav.sbl.dialogarena.common.abac.pep.domain.ResourceType;
import no.nav.sbl.dialogarena.common.abac.pep.exception.PepException;
import no.nav.sbl.rest.RestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VeilarbAbacPepClient
implements Helsesjekk {
    private static final String PATH_PERSON = "person";
    private static final String PATH_ENHET = "veilarbenhet";
    private static final String PATH_PING = "ping";
    private static final String ACTION_READ = "read";
    private static final String ACTION_UPDATE = "update";
    private static final String IDTYPE_FNR = "fnr";
    private static final String IDTYPE_AKTOR_ID = "aktorId";
    private static final String IDTYPE_ENHET_ID = "enhetId";
    private Logger logger = LoggerFactory.getLogger(VeilarbAbacPepClient.class);
    private Supplier<Boolean> brukAktoerIdSupplier = () -> false;
    private Supplier<Boolean> sammenliknTilgangSupplier = () -> false;
    private Supplier<Boolean> foretrekkVeilarbAbacSupplier = () -> false;
    private Supplier<String> systemUserTokenProvider;
    private Supplier<Optional<String>> oidcTokenSupplier = () -> SubjectHandler.getSsoToken((SsoToken.Type)SsoToken.Type.OIDC);
    private String abacTargetUrl;
    private PepClient pepClient;
    private String veilarbacOverstyrtRessurs;

    private VeilarbAbacPepClient() {
    }

    public static Builder ny() {
        return new Builder();
    }

    public void sjekkLesetilgangTilBruker(Bruker bruker) {
        new TilgangssjekkBruker().metrikkLogger(this.logger, ACTION_READ, bruker::getAktoerId).veilarbAbacFnrSjekker(() -> this.harVeilarbAbacTilgang(PATH_PERSON, ACTION_READ, IDTYPE_FNR, bruker.getFoedselsnummer())).veilarbAbacAktoerIdSjekker(() -> this.harVeilarbAbacTilgang(PATH_PERSON, ACTION_READ, IDTYPE_AKTOR_ID, bruker.getAktoerId())).abacFnrSjekker(() -> this.pepClient.sjekkLeseTilgangTilFnr(bruker.getFoedselsnummer())).foretrekkVeilarbAbac(this.foretrekkVeilarbAbacSupplier.get()).brukAktoerId(this.brukAktoerIdSupplier.get()).sammenliknTilgang(this.sammenliknTilgangSupplier.get()).sjekkTilgangTilBruker();
    }

    public void sjekkSkrivetilgangTilBruker(Bruker bruker) {
        new TilgangssjekkBruker().metrikkLogger(this.logger, ACTION_UPDATE, bruker::getAktoerId).veilarbAbacFnrSjekker(() -> this.harVeilarbAbacTilgang(PATH_PERSON, ACTION_UPDATE, IDTYPE_FNR, bruker.getFoedselsnummer())).veilarbAbacAktoerIdSjekker(() -> this.harVeilarbAbacTilgang(PATH_PERSON, ACTION_UPDATE, IDTYPE_AKTOR_ID, bruker.getAktoerId())).abacFnrSjekker(() -> this.pepClient.sjekkSkriveTilgangTilFnr(bruker.getFoedselsnummer())).foretrekkVeilarbAbac(this.foretrekkVeilarbAbacSupplier.get()).brukAktoerId(this.brukAktoerIdSupplier.get()).sammenliknTilgang(this.sammenliknTilgangSupplier.get()).sjekkTilgangTilBruker();
    }

    public boolean harTilgangTilEnhet(String enhetId) {
        return new TilgangssjekkEnhet().metrikkLogger(this.logger, ACTION_READ, () -> enhetId).veilarbAbacSjekker(() -> this.harVeilarbAbacTilgang(PATH_ENHET, ACTION_READ, IDTYPE_ENHET_ID, enhetId)).abacSjekker(() -> this.harAbacTilgangTilEnhet(enhetId)).foretrekkVeilarbAbac(this.foretrekkVeilarbAbacSupplier.get()).sammenliknTilgang(this.sammenliknTilgangSupplier.get()).sjekkTilgangTilEnhet();
    }

    @Override
    public void helsesjekk() {
        int status = (Integer)RestUtils.withClient(c -> c.target(this.abacTargetUrl).path(PATH_PING).request().get().getStatus());
        if (status != 200) {
            throw new IllegalStateException("Rest kall mot veilarbabac feilet");
        }
    }

    @Override
    public HelsesjekkMetadata getMetadata() {
        return new HelsesjekkMetadata("veilarbabac helsesjekk", this.abacTargetUrl, "Sjekker om veilarbabac endepunkt svarer", true);
    }

    private boolean harAbacTilgangTilEnhet(String enhetId) {
        try {
            return this.pepClient.harTilgangTilEnhet(enhetId);
        }
        catch (PepException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean harVeilarbAbacTilgang(String path, String action, String idType, String id) {
        return "permit".equals(RestUtils.withClient(c -> (String)this.overstyrRessurs(c.target(this.abacTargetUrl).path(path).queryParam(idType, new Object[]{id}).queryParam("action", new Object[]{action})).request().header("Authorization", (Object)("Bearer " + this.systemUserTokenProvider.get())).header("subject", (Object)this.oidcTokenSupplier.get().orElseThrow(() -> new IllegalStateException("Mangler OIDC-token"))).get(String.class)));
    }

    private WebTarget overstyrRessurs(WebTarget webTarget) {
        if (this.veilarbacOverstyrtRessurs != null) {
            return webTarget.queryParam("resource", new Object[]{this.veilarbacOverstyrtRessurs});
        }
        return webTarget;
    }

    public static class Builder {
        VeilarbAbacPepClient veilarbAbacPepClient = new VeilarbAbacPepClient();
        private Optional<String> veilarbAbacUrl = Optional.empty();
        private ResourceType resourceType = ResourceType.VeilArbPerson;
        private Pep pep;

        public Builder brukAktoerId(Supplier<Boolean> featureToggleSupplier) {
            this.veilarbAbacPepClient.brukAktoerIdSupplier = featureToggleSupplier;
            return this;
        }

        public Builder sammenlikneTilgang(Supplier<Boolean> featureToggleSupplier) {
            this.veilarbAbacPepClient.sammenliknTilgangSupplier = featureToggleSupplier;
            return this;
        }

        public Builder foretrekkVeilarbAbacResultat(Supplier<Boolean> featureToggleSupplier) {
            this.veilarbAbacPepClient.foretrekkVeilarbAbacSupplier = featureToggleSupplier;
            return this;
        }

        public Builder medPep(Pep pep) {
            this.pep = pep;
            return this;
        }

        public Builder medVeilarbAbacUrl(String url) {
            this.veilarbAbacUrl = Optional.of(url);
            return this;
        }

        public Builder medLogger(Logger logger) {
            this.veilarbAbacPepClient.logger = logger;
            return this;
        }

        public Builder medSystemUserTokenProvider(Supplier<String> systemUserTokenProvider) {
            this.veilarbAbacPepClient.systemUserTokenProvider = systemUserTokenProvider;
            return this;
        }

        public Builder medOidcTokenProvider(Supplier<Optional<String>> oidcTokenSupplier) {
            this.veilarbAbacPepClient.oidcTokenSupplier = oidcTokenSupplier;
            return this;
        }

        public Builder medResourceTypePerson() {
            this.resourceType = ResourceType.Person;
            this.veilarbAbacPepClient.veilarbacOverstyrtRessurs = "no.nav.abac.attributter.resource.felles.person";
            return this;
        }

        public VeilarbAbacPepClient bygg() {
            if (this.veilarbAbacPepClient.systemUserTokenProvider == null) {
                throw new IllegalStateException("SystemUserTokenProvider er ikke satt");
            }
            if (this.pep == null) {
                throw new IllegalStateException("Pep er ikke satt");
            }
            this.veilarbAbacPepClient.pepClient = new PepClient(this.pep, "veilarb", this.resourceType);
            this.veilarbAbacPepClient.abacTargetUrl = this.veilarbAbacUrl.orElseGet(() -> UrlUtils.clusterUrlForApplication("veilarbabac"));
            return this.veilarbAbacPepClient;
        }
    }
}

