/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.rest;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.nav.sbl.util.EnvironmentUtils;
import no.nav.sbl.util.StringUtils;

public class NavCorsFilter
implements Filter {
    public static final String ORIGIN = "Origin";
    public static final String CORS_ALLOWED_ORIGINS = "cors.allowed.origins";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ALLOWED_METHODS = Arrays.asList("GET", "HEAD", "POST", "PATCH", "PUT", "DELETE", "OPTIONS").stream().collect(Collectors.joining(", "));
    public List<String> ALLOWED_ORIGINS = NavCorsFilter.getAllowedOrigins();

    static List<String> getAllowedOrigins() {
        return EnvironmentUtils.getOptionalProperty((String)CORS_ALLOWED_ORIGINS, (String[])new String[0]).map(string -> string.split(",")).map(Stream::of).orElseGet(Stream::empty).map(String::trim).map(NavCorsFilter::validerSubdomene).collect(Collectors.toList());
    }

    private static String validerSubdomene(String subdomene) {
        if (subdomene.charAt(0) != '.') {
            throw new IllegalArgumentException("tillatt skal v\u00e6re subdomene, f.eks. '.nav.no' ikke 'nav.no'");
        }
        return subdomene;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String originHeader = httpServletRequest.getHeader(ORIGIN);
        if (this.validOrigin(originHeader)) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            httpServletResponse.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, originHeader);
            httpServletResponse.setHeader("Access-Control-Allow-Credentials", "true");
            httpServletResponse.setHeader("Access-Control-Allow-Methods", ALLOWED_METHODS);
        }
        chain.doFilter(request, response);
    }

    private boolean validOrigin(String originHeader) {
        return NavCorsFilter.validOrigin(originHeader, this.ALLOWED_ORIGINS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean validOrigin(String originHeader, List<String> allowedSubDomains) {
        if (!StringUtils.notNullOrEmpty((String)originHeader)) return false;
        if (!allowedSubDomains.stream().filter(StringUtils::notNullOrEmpty).anyMatch(originHeader::endsWith)) return false;
        return true;
    }

    public void destroy() {
    }
}

