/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.security.veilarbabac;

import java.util.Optional;
import java.util.function.Supplier;
import no.nav.apiapp.feil.IngenTilgang;
import no.nav.apiapp.security.veilarbabac.MetrikkLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TilgangssjekkBruker {
    private static final Logger logger = LoggerFactory.getLogger(TilgangssjekkBruker.class);
    private MetrikkLogger metrikk = new MetrikkLogger(logger, "read", () -> "");
    private Supplier<Boolean> veilarbabacFnrSjekker;
    private Supplier<Boolean> veilarbabacAktoerIdSjekker;
    private Runnable abacFnrSjekker = () -> {};
    private Boolean brukAktoerId = false;
    private Boolean sammenliknTilgang = false;
    private Boolean foretrekkVeilarbAbac = false;

    TilgangssjekkBruker() {
    }

    TilgangssjekkBruker metrikkLogger(Logger logger, String action, Supplier<String> idSupplier) {
        this.metrikk = new MetrikkLogger(logger, action, idSupplier);
        return this;
    }

    TilgangssjekkBruker veilarbAbacFnrSjekker(Supplier<Boolean> veilarbabacFnrSjekker) {
        this.veilarbabacFnrSjekker = veilarbabacFnrSjekker;
        return this;
    }

    TilgangssjekkBruker veilarbAbacAktoerIdSjekker(Supplier<Boolean> veilarbabacAktoerIdSjekker) {
        this.veilarbabacAktoerIdSjekker = veilarbabacAktoerIdSjekker;
        return this;
    }

    TilgangssjekkBruker abacFnrSjekker(Runnable abacFnrSjekker) {
        this.abacFnrSjekker = abacFnrSjekker;
        return this;
    }

    TilgangssjekkBruker foretrekkVeilarbAbac(boolean foretrekkVeilarbAbac) {
        this.foretrekkVeilarbAbac = foretrekkVeilarbAbac;
        return this;
    }

    TilgangssjekkBruker sammenliknTilgang(boolean sammenlikntilgang) {
        this.sammenliknTilgang = sammenlikntilgang;
        return this;
    }

    TilgangssjekkBruker brukAktoerId(boolean brukAktoerId) {
        this.brukAktoerId = brukAktoerId;
        return this;
    }

    void sjekkTilgangTilBruker() {
        boolean harTilgang = this.brukAktoerId != false && this.sammenliknTilgang != false ? this.sjekkOgSammenliknTilgangForAktoerIdOgFnr() : (this.sammenliknTilgang != false ? this.sjekkOgSammenliknTilgangForFnr() : (this.brukAktoerId != false ? this.tryggVeilarbabacAktorIdSjekker().orElse(false).booleanValue() : this.tryggAbacFnrSjekker().orElse(false).booleanValue()));
        this.metrikk.loggMetrikk(this.brukAktoerId != false ? MetrikkLogger.Tilgangstype.PersonAktoerId : MetrikkLogger.Tilgangstype.PersonFoedselsnummer, this.foretrekkVeilarbAbac);
        if (!harTilgang) {
            throw new IngenTilgang();
        }
    }

    private boolean sjekkOgSammenliknTilgangForFnr() {
        Optional<Boolean> veilarbAbacResultat = this.tryggVeilarbabacFnrSjekker();
        Optional<Boolean> abacResultat = this.tryggAbacFnrSjekker();
        if (veilarbAbacResultat.isPresent() && abacResultat.isPresent() && !abacResultat.equals(veilarbAbacResultat)) {
            this.metrikk.erAvvik();
        }
        return this.foretrekkVeilarbAbac != false ? veilarbAbacResultat.orElse(abacResultat.orElse(false)).booleanValue() : abacResultat.orElse(veilarbAbacResultat.orElse(false)).booleanValue();
    }

    private boolean sjekkOgSammenliknTilgangForAktoerIdOgFnr() {
        Optional<Boolean> aktoerIdResultat = this.tryggVeilarbabacAktorIdSjekker();
        Optional<Boolean> fnrResultat = this.tryggVeilarbabacFnrSjekker();
        if (fnrResultat.isPresent() && aktoerIdResultat.isPresent() && !fnrResultat.equals(aktoerIdResultat)) {
            this.metrikk.erAvvik();
        }
        return fnrResultat.orElse(aktoerIdResultat.orElse(false));
    }

    private Optional<Boolean> tryggVeilarbabacFnrSjekker() {
        Optional<Boolean> fnrResultat = Optional.empty();
        try {
            fnrResultat = Optional.of(this.veilarbabacFnrSjekker.get());
        }
        catch (Throwable e) {
            logger.error("Kall mot veilarbAbac (fnr) feiler", e);
        }
        return fnrResultat;
    }

    private Optional<Boolean> tryggVeilarbabacAktorIdSjekker() {
        Optional<Boolean> aktoerIdResultat = Optional.empty();
        try {
            aktoerIdResultat = Optional.of(this.veilarbabacAktoerIdSjekker.get());
        }
        catch (Throwable e) {
            logger.error("Kall mot veilarbAbac (akt\u00f8rId) feiler", e);
        }
        return aktoerIdResultat;
    }

    private Optional<Boolean> tryggAbacFnrSjekker() {
        try {
            this.abacFnrSjekker.run();
            return Optional.of(true);
        }
        catch (IngenTilgang e) {
            return Optional.of(false);
        }
        catch (Throwable e) {
            logger.error("Kall mot abac feiler", e);
            return Optional.empty();
        }
    }
}

