/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.soap;

import java.util.Collection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import no.nav.apiapp.ServletUtil;
import no.nav.apiapp.soap.MethodInvokerMedFeilhandtering;
import no.nav.apiapp.soap.SoapFaultListener;
import no.nav.apiapp.soap.SoapTjeneste;
import no.nav.sbl.dialogarena.common.cxf.CXFEndpoint;
import no.nav.sbl.dialogarena.common.cxf.saml.CXFServletWithAuth;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.logging.FaultListener;
import org.apache.cxf.service.invoker.Invoker;

public class SoapServlet
extends CXFServletWithAuth {
    public static boolean soapTjenesterEksisterer(ServletContext servletContext) {
        return !SoapServlet.getSoapTjenester(servletContext).isEmpty();
    }

    protected void loadBus(ServletConfig servletConfig) {
        super.loadBus(servletConfig);
        BusFactory.setDefaultBus((Bus)this.getBus());
        SoapServlet.getSoapTjenester(servletConfig.getServletContext()).forEach(serviceBean -> {
            CXFEndpoint cxfEndpoint = new CXFEndpoint().address(serviceBean.getClass().getAnnotation(SoapTjeneste.class).value()).serviceBean(serviceBean);
            cxfEndpoint.factoryBean.setInvoker((Invoker)new MethodInvokerMedFeilhandtering(serviceBean));
            cxfEndpoint.setProperty(FaultListener.class.getName(), (Object)new SoapFaultListener());
            cxfEndpoint.create();
        });
    }

    private static Collection<Object> getSoapTjenester(ServletContext servletContext) {
        return ServletUtil.getContext(servletContext).getBeansWithAnnotation(SoapTjeneste.class).values();
    }
}

