/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRegistration;
import no.nav.apiapp.servlet.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ServletUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletUtil.class);

    public static WebApplicationContext getContext(ServletContext servletContext) {
        return WebApplicationContextUtils.findWebApplicationContext((ServletContext)servletContext);
    }

    public static WebApplicationContext getContext(ServletContextEvent servletContextEvent) {
        return ServletUtil.getContext(servletContextEvent.getServletContext());
    }

    public static AnnotationConfigWebApplicationContext getSpringContext(ServletContextEvent servletContextEvent) {
        return (AnnotationConfigWebApplicationContext)ServletUtil.getContext(servletContextEvent.getServletContext());
    }

    public static ServletRegistration.Dynamic leggTilServlet(ServletContextEvent servletContextEvent, Class<? extends Servlet> servletClass, String ... path) {
        return ServletUtil.leggTilServlet(servletContextEvent.getServletContext(), servletClass, path);
    }

    public static ServletRegistration.Dynamic leggTilServlet(ServletContext servletContext, Class<? extends Servlet> servletClass, String ... path) {
        ServletRegistration.Dynamic dynamic = servletContext.addServlet(servletClass.getName(), servletClass);
        dynamic.setLoadOnStartup(0);
        dynamic.addMapping(path);
        LOGGER.info("la til servlet [{}] p\u00e5 [{}]", (Object)servletClass.getName(), (Object)path);
        return dynamic;
    }

    public static ServletRegistration.Dynamic leggTilServlet(ServletContextEvent servletContextEvent, Servlet servlet, String path) {
        return ServletUtil.leggTilServlet(servletContextEvent.getServletContext(), servlet, path);
    }

    public static ServletRegistration.Dynamic leggTilServlet(ServletContext servletContext, Servlet servlet, String path) {
        ServletRegistration.Dynamic servletRegistration = servletContext.addServlet(servlet.getClass().getName(), servlet);
        servletRegistration.setLoadOnStartup(0);
        servletRegistration.addMapping(new String[]{path});
        LOGGER.info("la til servlet [{}] p\u00e5 [{}]", (Object)servlet, (Object)path);
        return servletRegistration;
    }

    @Deprecated
    public static FilterRegistration.Dynamic leggTilFilter(ServletContextEvent servletContextEvent, Class<? extends Filter> filterClass) {
        return ServletUtil.leggTilFilter(servletContextEvent.getServletContext(), filterClass);
    }

    @Deprecated
    public static FilterRegistration.Dynamic leggTilFilter(ServletContext servletContext, Class<? extends Filter> filterClass) {
        FilterRegistration.Dynamic dynamic = servletContext.addFilter(filterClass.getName(), filterClass);
        dynamic.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"/*"});
        LOGGER.info("la til filter [{}]", (Object)filterClass.getName());
        return dynamic;
    }

    @Deprecated
    public static FilterRegistration.Dynamic leggTilFilter(ServletContextEvent servletContextEvent, Filter filter) {
        return ServletUtil.leggTilFilter(servletContextEvent.getServletContext(), filter);
    }

    @Deprecated
    public static FilterRegistration.Dynamic leggTilFilter(ServletContext servletContext, Filter filter) {
        Class<?> filterClass = filter.getClass();
        FilterRegistration.Dynamic dynamic = servletContext.addFilter(filterClass.getName(), filter);
        dynamic.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"/*"});
        LOGGER.info("la til filter [{}]", (Object)filterClass.getName());
        return dynamic;
    }

    public static FilterBuilder filterBuilder(Class<? extends Filter> filterClass) {
        return new FilterBuilder(filterClass);
    }

    public static FilterBuilder filterBuilder(Filter filter) {
        return new FilterBuilder(filter);
    }
}

