/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.version;

import ch.qos.logback.core.Context;
import com.fasterxml.jackson.core.JsonFactory;
import io.micrometer.core.instrument.Meter;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import net.sf.ehcache.Ehcache;
import no.nav.apiapp.ApiApplication;
import no.nav.apiapp.version.Version;
import no.nav.sbl.util.EnvironmentUtils;
import org.apache.cxf.Bus;
import org.eclipse.jetty.util.Jetty;
import org.glassfish.jersey.CommonProperties;
import org.jose4j.jwt.JwtClaims;
import org.springframework.core.Constants;

public class VersionService {
    static final String UNKNOWN_VERSION = "?";

    public List<Version> getVersions() {
        return Arrays.asList(this.version("java", EnvironmentUtils.getRequiredProperty((String)"java.version", (String[])new String[0])), this.version("common", ApiApplication.class), this.version("jetty", Jetty.VERSION), this.version("spring", Constants.class), this.version("logback", Context.class), this.version("cxf", Bus.class), this.version("jersey", CommonProperties.class), this.version("jose4j", JwtClaims.class), this.version("ehcache", Ehcache.class), this.version("micrometer", Meter.class), this.version("jackson", JsonFactory.class));
    }

    private Version version(String spring, Class<?> aClass) {
        return this.version(spring, this.resolveManifestVersion(aClass));
    }

    private Version version(String component, String version) {
        return Version.builder().component(component).version(version).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String resolveManifestVersion(Class<?> applicationContextClass) {
        Package classPackage = applicationContextClass.getPackage();
        String implementationVersion = classPackage.getImplementationVersion();
        if (implementationVersion != null) {
            return implementationVersion;
        }
        URL jarUrl = applicationContextClass.getProtectionDomain().getCodeSource().getLocation();
        try (InputStream inputStream = jarUrl.openStream();
             JarInputStream jarStream = new JarInputStream(inputStream);){
            Manifest manifest = jarStream.getManifest();
            if (manifest == null) return UNKNOWN_VERSION;
            String string = manifest.getMainAttributes().entrySet().stream().filter(e -> new Attributes.Name("Bundle-Version").equals(e.getKey())).map(Map.Entry::getValue).flatMap(this::attributeValuetoString).findFirst().orElse(UNKNOWN_VERSION);
            return string;
        }
    }

    private Stream<String> attributeValuetoString(Object versionAttribute) {
        return Optional.ofNullable(versionAttribute).map(Object::toString).map(Stream::of).orElseGet(Stream::empty);
    }
}

