/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.security.veilarbabac;

import java.util.Objects;
import java.util.function.Supplier;
import no.nav.sbl.util.StringUtils;

public class Bruker {
    private String fnr;
    private String originaltFnr;
    private String aktoerId;
    private String originalAktoerId;
    private Supplier<String> aktoerIdSupplier;
    private Supplier<String> fnrSupplier;

    public static FnrBuilder fraFnr(String fnr) {
        if (StringUtils.nullOrEmpty((String)fnr)) {
            throw new IllegalArgumentException("fnr m\u00e5 ha verdi");
        }
        return new FnrBuilder(fnr);
    }

    public static AktoerIdBuilder fraAktoerId(String aktoerId) {
        if (StringUtils.nullOrEmpty((String)aktoerId)) {
            throw new IllegalArgumentException("aktoerId m\u00e5 ha verdi");
        }
        return new AktoerIdBuilder(aktoerId);
    }

    public String getFoedselsnummer() {
        if (this.fnr == null) {
            this.fnr = this.fnrSupplier.get();
        }
        return this.fnr;
    }

    public String getAktoerId() {
        if (this.aktoerId == null) {
            this.aktoerId = this.aktoerIdSupplier.get();
        }
        return this.aktoerId;
    }

    public String toString() {
        return "Bruker{fnr='" + this.fnr + '\'' + ", aktoerId='" + this.aktoerId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bruker bruker = (Bruker)o;
        return Objects.equals(this.originaltFnr, bruker.originaltFnr) && Objects.equals(this.originalAktoerId, bruker.originalAktoerId);
    }

    public int hashCode() {
        return Objects.hash(this.originaltFnr, this.originalAktoerId);
    }

    public static class AktoerIdBuilder {
        Bruker bruker = new Bruker();

        private AktoerIdBuilder(String aktoerId) {
            this.bruker.aktoerId = (this.bruker.originalAktoerId = aktoerId);
        }

        public Bruker medFoedselsnummer(String fnr) {
            if (StringUtils.nullOrEmpty((String)fnr)) {
                throw new IllegalArgumentException("fnr m\u00e5 ha verdi");
            }
            this.bruker.fnr = (this.bruker.originaltFnr = fnr);
            return this.bruker;
        }

        public Bruker medFoedselnummerSupplier(Supplier<String> fnrSupplier) {
            this.bruker.fnrSupplier = fnrSupplier;
            return this.bruker;
        }
    }

    public static class FnrBuilder {
        Bruker bruker = new Bruker();

        private FnrBuilder(String fnr) {
            this.bruker.fnr = (this.bruker.originaltFnr = fnr);
        }

        public Bruker medAktoerId(String aktoerId) {
            if (StringUtils.nullOrEmpty((String)aktoerId)) {
                throw new IllegalArgumentException("aktoerId m\u00e5 ha verdi");
            }
            this.bruker.aktoerId = (this.bruker.originalAktoerId = aktoerId);
            return this.bruker;
        }

        public Bruker medAktoerIdSupplier(Supplier<String> aktoerIdSupplier) {
            this.bruker.aktoerIdSupplier = aktoerIdSupplier;
            return this.bruker;
        }
    }
}

