/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import no.nav.apiapp.security.SecurityLevelAuthorizationModule;
import no.nav.brukerdialog.security.domain.IdentType;
import no.nav.common.auth.AuthorizationModule;
import no.nav.common.auth.SecurityLevel;
import no.nav.common.auth.Subject;

public class ApiAppAuthorizationModule
implements AuthorizationModule {
    private AuthorizationModule customAuthorizationModule;
    private SecurityLevel defaultSecurityLevel;
    private Map<String, SecurityLevel> pathToSecurityLevel;

    public ApiAppAuthorizationModule(AuthorizationModule customAuthorizationModule, SecurityLevel defaultSecurityLevel, Map<SecurityLevel, List<String>> securityLevelForBasePaths) {
        this.customAuthorizationModule = customAuthorizationModule;
        this.defaultSecurityLevel = defaultSecurityLevel;
        this.pathToSecurityLevel = this.mapAndValidateSecurityLevels(securityLevelForBasePaths);
    }

    private Map<String, SecurityLevel> mapAndValidateSecurityLevels(Map<SecurityLevel, List<String>> securityLevelForPaths) {
        HashMap<String, SecurityLevel> map = new HashMap<String, SecurityLevel>();
        securityLevelForPaths.forEach((key, value) -> value.forEach(path -> {
            if (map.containsKey(path)) {
                throw new IllegalStateException("Ambiguous security level for " + path);
            }
            if (!path.matches("^[^/?&=]+$")) {
                throw new IllegalStateException("Invalid path for security level " + path);
            }
            map.put((String)path, (SecurityLevel)key);
        }));
        return map;
    }

    public boolean authorized(Subject subject, HttpServletRequest httpServletRequest) {
        return this.securityLevelAuthorization(subject, httpServletRequest) && this.customAuthorization(subject, httpServletRequest);
    }

    private boolean securityLevelAuthorization(Subject subject, HttpServletRequest httpServletRequest) {
        return !IdentType.EksternBruker.equals((Object)subject.getIdentType()) || this.securityLevelForPathsAuthorization(subject, httpServletRequest).orElse(this.defaultSecurityLevelAuthorization(subject, httpServletRequest)) != false;
    }

    private boolean defaultSecurityLevelAuthorization(Subject subject, HttpServletRequest httpServletRequest) {
        return Optional.ofNullable(this.defaultSecurityLevel).map(defaultSecurityLevel -> SecurityLevelAuthorizationModule.authorized(subject, httpServletRequest, defaultSecurityLevel)).orElse(true);
    }

    private Optional<Boolean> securityLevelForPathsAuthorization(Subject subject, HttpServletRequest httpServletRequest) {
        SecurityLevel securityLevel = SecurityLevelAuthorizationModule.getSecurityLevel(subject);
        Optional<SecurityLevel> requiredSecurityLevel = this.getRequiredSecurityLevel(httpServletRequest);
        return requiredSecurityLevel.map(required -> securityLevel.getSecurityLevel() >= required.getSecurityLevel());
    }

    private Optional<SecurityLevel> getRequiredSecurityLevel(HttpServletRequest httpServletRequest) {
        return this.getSecurityLevelKey(httpServletRequest).flatMap(str -> Optional.ofNullable(this.pathToSecurityLevel.get(str)));
    }

    private Optional<String> getSecurityLevelKey(HttpServletRequest httpServletRequest) {
        return Optional.ofNullable(httpServletRequest.getPathInfo()).map(str -> str.substring(1)).map(str -> {
            if (str.indexOf(47) != -1) {
                return str.substring(0, str.indexOf(47));
            }
            return str;
        });
    }

    private boolean customAuthorization(Subject subject, HttpServletRequest httpServletRequest) {
        return Optional.ofNullable(this.customAuthorizationModule).map(authModule -> authModule.authorized(subject, httpServletRequest)).orElse(true);
    }
}

