/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.EventListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.nav.apiapp.ApiAppServletContextListener;
import no.nav.apiapp.ApiApplication;
import no.nav.apiapp.ShutdownHook;
import no.nav.apiapp.config.Konfigurator;
import no.nav.apiapp.feil.FeilMapper;
import no.nav.apiapp.util.UrlUtils;
import no.nav.apiapp.util.WarFolderFinderUtil;
import no.nav.metrics.Event;
import no.nav.metrics.MetricsFactory;
import no.nav.sbl.dialogarena.common.jetty.Jetty;
import no.nav.sbl.dialogarena.common.jetty.JettyCustomizer;
import no.nav.sbl.util.EnvironmentUtils;
import no.nav.sbl.util.StringUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiApp {
    public static final String TRUSTSTORE = "javax.net.ssl.trustStore";
    public static final String TRUSTSTOREPASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String NAV_TRUSTSTORE_PATH = "NAV_TRUSTSTORE_PATH";
    public static final String NAV_TRUSTSTORE_PASSWORD = "NAV_TRUSTSTORE_PASSWORD";
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiApp.class);
    static final int DEFAULT_HTTP_PORT = 8080;
    private final Jetty jetty;

    public ApiApp(Jetty jetty) {
        this.jetty = jetty;
    }

    public Jetty getJetty() {
        return this.jetty;
    }

    @Deprecated
    public static void startApp(Class<? extends ApiApplication> apiAppClass, String[] args) {
        ApiApp.runApp(apiAppClass, args);
    }

    public static void runApp(Class<? extends ApiApplication> apiAppClass, String[] args) {
        ApiApp apiApp = ApiApp.startApiApp(apiAppClass, args);
        Jetty jetty = apiApp.jetty;
        jetty.server.join();
    }

    public static ApiApp startApiApp(Class<? extends ApiApplication> apiAppClass, String[] args) {
        long start = System.currentTimeMillis();
        ApiApp.setupTrustStore();
        ApiApplication apiApplication = apiAppClass.newInstance();
        Jetty jetty = ApiApp.setupJetty(apiApplication, args);
        ApiApp.reportStartupTime(start);
        return new ApiApp(jetty);
    }

    private static Jetty setupJetty(ApiApplication apiApplication, String[] args) throws IOException {
        int httpPort = ApiApp.httpPort(args);
        File file = WarFolderFinderUtil.findPath(apiApplication.getClass());
        LOGGER.info("starter med war p\u00e5: {}", (Object)file.getCanonicalPath());
        String contextPath = StringUtils.of((String)apiApplication.getContextPath()).map(UrlUtils::startMedSlash).orElse("/");
        Jetty.JettyBuilder jettyBuilder = Jetty.usingWar((File)file).at(contextPath).port(httpPort).disableAnnotationScanning().disableStatistics().addCustomizer(new JettyCustomizer(){

            public void customize(HttpConfiguration httpConfiguration) {
                httpConfiguration.setSendServerVersion(false);
            }
        });
        if (args.length > 1) {
            jettyBuilder.sslPort(Integer.parseInt(args[1]));
        }
        Konfigurator konfigurator = new Konfigurator(jettyBuilder, apiApplication);
        apiApplication.configure(konfigurator);
        Jetty jetty = konfigurator.buildJetty();
        WebAppContext webAppContext = jetty.context;
        webAppContext.addEventListener((EventListener)((Object)new ApiAppServletContextListener(konfigurator, apiApplication)));
        Server server = jetty.server;
        if (contextPath.length() > 1) {
            HandlerCollection handlerCollection = new HandlerCollection();
            handlerCollection.addHandler(server.getHandler());
            handlerCollection.addHandler((Handler)new RootToContextRedirectHandler(contextPath));
            server.setHandler((Handler)handlerCollection);
        }
        Jetty.addStatisticsHandler((Server)server);
        webAppContext.setClassLoader((ClassLoader)URLClassLoader.newInstance(new URL[0]));
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(FeilMapper.visDetaljer());
        jetty.server.setErrorHandler(errorHandler);
        jetty.context.setErrorHandler(errorHandler);
        try {
            jetty.start();
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            System.exit(1);
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownHook(jetty));
        return jetty;
    }

    private static void setupTrustStore() {
        if (EnvironmentUtils.getOptionalProperty((String)TRUSTSTORE, (String[])new String[0]).isPresent()) {
            return;
        }
        EnvironmentUtils.getOptionalProperty((String)NAV_TRUSTSTORE_PATH, (String[])new String[0]).ifPresent(path -> EnvironmentUtils.setProperty((String)TRUSTSTORE, (String)path, (EnvironmentUtils.Type)EnvironmentUtils.Type.PUBLIC));
        EnvironmentUtils.getOptionalProperty((String)NAV_TRUSTSTORE_PASSWORD, (String[])new String[0]).ifPresent(passwd -> EnvironmentUtils.setProperty((String)TRUSTSTOREPASSWORD, (String)passwd, (EnvironmentUtils.Type)EnvironmentUtils.Type.SECRET));
    }

    private static void reportStartupTime(long start) {
        long startupTime = System.currentTimeMillis() - start;
        LOGGER.info("oppstartstid: {} ms", (Object)startupTime);
        Event event = MetricsFactory.createEvent((String)"startup");
        event.addFieldToReport("time", (Object)startupTime);
        event.report();
    }

    private static int httpPort(String[] args) {
        if (args.length > 0) {
            return Integer.parseInt(args[0]);
        }
        return 8080;
    }

    private static class RootToContextRedirectHandler
    extends AbstractHandler {
        private final String contextPath;

        private RootToContextRedirectHandler(String contextPath) {
            this.contextPath = contextPath;
        }

        public void handle(String requestPath, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
            if ("/".equals(requestPath)) {
                httpServletResponse.sendRedirect(this.contextPath);
                request.setHandled(true);
            }
        }
    }
}

