/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.rest;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import no.nav.apiapp.ApiApplication;
import no.nav.apiapp.util.UrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerUIServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerUIServlet.class);
    private final ApiApplication apiApplication;

    public SwaggerUIServlet(ApiApplication apiApplication) {
        this.apiApplication = apiApplication;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String etterspurtFil = request.getRequestURI().substring(request.getContextPath().length() + request.getServletPath().length());
        if ("".equals(etterspurtFil)) {
            response.sendRedirect("./swagger/");
        } else if ("/".equals(etterspurtFil)) {
            response.sendRedirect("./index.html?input_baseurl=" + UrlUtils.joinPaths(request.getContextPath(), this.apiApplication.getApiBasePath(), "swagger.json"));
        } else {
            this.dispatch("/webjars/swagger-ui/2.2.10" + etterspurtFil, request, response);
        }
    }

    private void dispatch(String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.info("forward: [{}] -> [{}]", (Object)request.getRequestURI(), (Object)path);
        RequestDispatcher requestDispatcher = this.getServletContext().getNamedDispatcher("default");
        requestDispatcher.forward((ServletRequest)new SwaggerRequest(request, path), (ServletResponse)response);
    }

    private static class SwaggerRequest
    extends HttpServletRequestWrapper {
        private final String path;

        private SwaggerRequest(HttpServletRequest request, String path) {
            super(request);
            this.path = path;
        }

        public String getServletPath() {
            return "/";
        }

        public String getPathInfo() {
            return this.path;
        }
    }
}

