/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.metrics;

import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.MetricsServlet;
import io.prometheus.client.exporter.common.TextFormat;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.nav.apiapp.util.StringUtils;
import no.nav.apiapp.version.Version;
import no.nav.metrics.MetricsFactory;
import no.nav.sbl.dialogarena.common.web.selftest.SelfTestService;
import no.nav.sbl.dialogarena.common.web.selftest.domain.Selftest;
import no.nav.sbl.dialogarena.common.web.selftest.domain.SelftestResult;

public class PrometheusServlet
extends MetricsServlet {
    public static final String SELFTESTS_AGGREGATE_RESULT = "selftests_aggregate_result";
    public static final String AGGREGATE_STATUS_ID = "selftests_aggregate_result_status";
    public static final String AGGREGATE_TIME_ID = "selftests_aggregate_result_time";
    public static final String SELFTEST_STATUS_ID = "selftest_status";
    public static final String SELFTEST_TIME_ID = "selftest_time";
    private static final PrometheusMeterRegistry PROMETHEUS_METER_REGISTRY = (PrometheusMeterRegistry)MetricsFactory.getMeterRegistry();
    private final SelfTestService selfTestService;
    private final List<Collector.MetricFamilySamples> versionSamples;

    public PrometheusServlet(SelfTestService selfTestService, List<Version> versionSamples) {
        this.selfTestService = selfTestService;
        this.versionSamples = this.versions(versionSamples);
    }

    public void init() throws ServletException {
        DefaultExports.initialize();
        super.init();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(200);
        response.setContentType("text/plain; version=0.0.4; charset=utf-8");
        try (PrintWriter responseWriter = response.getWriter();){
            PrometheusServlet.write(responseWriter, CollectorRegistry.defaultRegistry.metricFamilySamples());
            responseWriter.write(PROMETHEUS_METER_REGISTRY.scrape());
            PrometheusServlet.write(responseWriter, this.selfTests());
            PrometheusServlet.write(responseWriter, Collections.enumeration(this.versionSamples));
        }
    }

    static void write(Writer printWriter, Enumeration<Collector.MetricFamilySamples> samplesEnumeration) throws IOException {
        TextFormat.write004((Writer)printWriter, samplesEnumeration);
    }

    private List<Collector.MetricFamilySamples> versions(List<Version> versions) {
        return Collections.singletonList(new Collector.MetricFamilySamples("version", Collector.Type.GAUGE, "displays component versions", versions.stream().map(this::versionSample).collect(Collectors.toList())));
    }

    private Collector.MetricFamilySamples.Sample versionSample(Version version) {
        return new Collector.MetricFamilySamples.Sample("version", Arrays.asList("component", "version"), Arrays.asList(version.component, version.version), 1.0);
    }

    Enumeration<Collector.MetricFamilySamples> selfTests() {
        long start = System.currentTimeMillis();
        Selftest selftest = this.selfTestService.selfTest();
        long tid = System.currentTimeMillis() - start;
        List selftestResults = selftest.getChecks();
        ArrayList<Collector.MetricFamilySamples> samples = new ArrayList<Collector.MetricFamilySamples>();
        samples.add(new Collector.MetricFamilySamples(AGGREGATE_STATUS_ID, Collector.Type.UNTYPED, "aggregert status for alle selftester. 0=ok, 1=kritisk feil, 2=ikke-kritisk feil", Collections.singletonList(this.aggregateSample(AGGREGATE_STATUS_ID, PrometheusServlet.aggregertStatus(selftestResults).statusKode))));
        samples.add(new Collector.MetricFamilySamples(AGGREGATE_TIME_ID, Collector.Type.GAUGE, "total tid alle selftester", Collections.singletonList(this.aggregateSample(AGGREGATE_TIME_ID, tid))));
        samples.add(new Collector.MetricFamilySamples(SELFTEST_STATUS_ID, Collector.Type.UNTYPED, "status for selftest. 0=ok, 1=kritisk feil, 2=ikke-kritisk feil", selftestResults.stream().map(result -> this.pingSample((SelftestResult)result, SELFTEST_STATUS_ID, PrometheusServlet.status(result).statusKode)).collect(Collectors.toList())));
        samples.add(new Collector.MetricFamilySamples(SELFTEST_TIME_ID, Collector.Type.GAUGE, "responstid for selftest", selftestResults.stream().map(result -> this.pingSample((SelftestResult)result, SELFTEST_TIME_ID, result.getResponseTime())).collect(Collectors.toList())));
        return Collections.enumeration(samples);
    }

    static Status aggregertStatus(List<SelftestResult> selftestResults) {
        return selftestResults.stream().map(PrometheusServlet::status).max(Enum::compareTo).orElse(Status.OK);
    }

    private static Status status(SelftestResult selftestResult) {
        return selftestResult.harFeil() ? (selftestResult.isCritical() ? Status.ERROR : Status.WARNING) : Status.OK;
    }

    private Collector.MetricFamilySamples.Sample aggregateSample(String id, double value) {
        return new Collector.MetricFamilySamples.Sample(id, Collections.emptyList(), Collections.emptyList(), value);
    }

    private Collector.MetricFamilySamples.Sample pingSample(SelftestResult selftestResult, String sampleId, double value) {
        return new Collector.MetricFamilySamples.Sample(sampleId, Collections.singletonList("id"), Collections.singletonList(StringUtils.of(selftestResult.getId()).orElseThrow(IllegalArgumentException::new)), value);
    }

    static enum Status {
        OK(0),
        WARNING(2),
        ERROR(1);

        private final int statusKode;

        private Status(int statusKode) {
            this.statusKode = statusKode;
        }
    }
}

