/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.security;

import javax.servlet.http.HttpServletRequest;
import no.nav.brukerdialog.security.oidc.OidcTokenUtils;
import no.nav.common.auth.AuthorizationModule;
import no.nav.common.auth.SecurityLevel;
import no.nav.common.auth.SsoToken;
import no.nav.common.auth.Subject;
import no.nav.common.auth.openam.sbs.OpenAmUtils;

public class SecurityLevelAuthorizationModule
implements AuthorizationModule {
    private final SecurityLevel minimumLevel;

    public SecurityLevelAuthorizationModule(SecurityLevel minimumLevel) {
        this.minimumLevel = minimumLevel;
    }

    public boolean authorized(Subject subject, HttpServletRequest httpServletRequest) {
        return SecurityLevelAuthorizationModule.authorized(subject, httpServletRequest, this.minimumLevel);
    }

    public static boolean authorized(Subject subject, HttpServletRequest httpServletRequest, SecurityLevel minimumLevel) {
        return subject != null && SecurityLevelAuthorizationModule.getSecurityLevel(subject).getSecurityLevel() >= minimumLevel.getSecurityLevel();
    }

    public static SecurityLevel getSecurityLevel(Subject subject) {
        SsoToken ssoToken = subject.getSsoToken();
        switch (ssoToken.getType()) {
            case OIDC: {
                return OidcTokenUtils.getOidcSecurityLevel((SsoToken)ssoToken);
            }
            case EKSTERN_OPENAM: {
                return OpenAmUtils.getSecurityLevel((SsoToken)ssoToken);
            }
        }
        return SecurityLevel.Ukjent;
    }
}

