/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.rest;

import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import no.nav.apiapp.feil.Feil;
import no.nav.apiapp.feil.FeilDTO;
import no.nav.apiapp.feil.FeilMapper;
import no.nav.metrics.Event;
import no.nav.metrics.MetricsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ExceptionMapper
implements javax.ws.rs.ext.ExceptionMapper<Throwable> {
    public static final String ESCAPE_REDIRECT_HEADER = "Escape-5xx-Redirect";
    public static final String ESCAPE_REDIRECT_X_HEADER = "X-Escape-5xx-Redirect";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionMapper.class);
    @Inject
    javax.inject.Provider<HttpServletRequest> servletRequestProvider;

    public ExceptionMapper() {
    }

    public ExceptionMapper(javax.inject.Provider<HttpServletRequest> servletRequestProvider) {
        this.servletRequestProvider = servletRequestProvider;
    }

    public Response toResponse(Throwable exception) {
        return this.toResponse(exception, this.getStatus(exception), FeilMapper.somFeilDTO(exception));
    }

    public Response toResponse(Throwable exception, Feil.Type type) {
        return this.toResponse(exception, type.getStatus(), FeilMapper.somFeilDTO(exception, type));
    }

    private Response toResponse(Throwable exception, Response.Status status, FeilDTO feil) {
        String path = ((HttpServletRequest)this.servletRequestProvider.get()).getRequestURI();
        if (status.getStatusCode() < 500) {
            LOGGER.warn("{} - {} - {}", new Object[]{path, status, feil});
            LOGGER.warn(exception.getMessage(), exception);
        } else {
            LOGGER.error("{} - {} - {}", new Object[]{path, status, feil});
            LOGGER.error(exception.getMessage(), exception);
        }
        this.logToMetrics(status, path, feil);
        return Response.status((Response.Status)status).entity((Object)feil).header(ESCAPE_REDIRECT_HEADER, (Object)"true").header(ESCAPE_REDIRECT_X_HEADER, (Object)"true").build();
    }

    private void logToMetrics(Response.Status status, String path, FeilDTO feilDTO) {
        Event event = (Event)((Event)((Event)((Event)MetricsFactory.createEvent((String)"rest-api-error").addFieldToReport("httpStatus", (Object)status.getStatusCode())).addFieldToReport("path", (Object)path)).addFieldToReport("errorId", (Object)feilDTO.id)).addFieldToReport("errorType", (Object)feilDTO.type);
        Optional.ofNullable(feilDTO.detaljer).ifPresent(detaljer -> {
            Event cfr_ignored_0 = (Event)((Event)event.addTagToReport("detaljertType", detaljer.detaljertType)).addTagToReport("feilMelding", detaljer.feilMelding);
        });
        ((Event)event.setFailed()).report();
    }

    private Response.Status getStatus(Throwable throwable) {
        if (throwable instanceof WebApplicationException) {
            return Response.Status.fromStatusCode((int)((WebApplicationException)throwable).getResponse().getStatus());
        }
        return FeilMapper.getType(throwable).getStatus();
    }
}

