/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.jaxrs.config.DefaultJaxrsScanner;
import io.swagger.jaxrs.config.ReaderConfigUtils;
import io.swagger.jaxrs.listing.BaseApiListingResource;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import no.nav.apiapp.ApiApplication;
import no.nav.apiapp.util.UrlUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
@Path(value="/swagger.json")
public class SwaggerResource
extends BaseApiListingResource {
    public static final String SWAGGER_JSON = "swagger.json";
    public static final String IKKE_BERIK = "ikke_berik";
    private final ApiApplication apiApplication;
    private final boolean hasLogin;
    @Inject
    private Provider<HttpServletRequest> httpServletRequestProvider;

    public static void setupServlet(ServletRegistration.Dynamic servletRegistration) {
        servletRegistration.setInitParameter("scan.all.resources", "true");
    }

    public SwaggerResource(ApiApplication apiApplication, boolean hasLogin) {
        this.apiApplication = apiApplication;
        this.hasLogin = hasLogin;
    }

    @GET
    public javax.ws.rs.core.Response getSwaggerJSON(@Context Application application, @Context ServletConfig servletConfig, @Context ServletContext servletContext, @Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @QueryParam(value="ikke_berik") String ikkeBerik) throws JsonProcessingException {
        ReaderConfigUtils.initReaderConfig((ServletConfig)servletConfig);
        return this.getListingJsonResponse(application, servletContext, servletConfig, httpHeaders, uriInfo);
    }

    protected Swagger process(Application app, ServletContext servletContext, ServletConfig sc, HttpHeaders headers, UriInfo uriInfo) {
        Swagger swagger = super.process(app, servletContext, sc, headers, uriInfo);
        if (!((HttpServletRequest)this.httpServletRequestProvider.get()).getParameterMap().containsKey(IKKE_BERIK)) {
            return this.berik(this.kopier(swagger), app, servletContext, sc);
        }
        return swagger;
    }

    private Swagger kopier(Swagger swagger) {
        ObjectMapper mapper = Json.mapper();
        return (Swagger)mapper.readValue(mapper.writeValueAsString((Object)swagger), Swagger.class);
    }

    private Swagger berik(Swagger swagger, Application app, ServletContext servletContext, ServletConfig sc) {
        swagger.setBasePath(servletContext.getContextPath() + UrlUtils.sluttMedSlash(this.apiApplication.getApiBasePath()));
        SwaggerRequest swaggerRequest = new SwaggerRequest(swagger);
        new DefaultJaxrsScanner().classesFromContext(app, sc).forEach(res -> this.leggTilStandardDokumentasjon(swaggerRequest, (Class<?>)res));
        return swagger;
    }

    private void leggTilStandardDokumentasjon(SwaggerRequest swaggerRequest, Class<?> contextClass) {
        Optional.ofNullable(AnnotationUtils.findAnnotation(contextClass, Path.class)).map(Path::value).map(this::prependSlash).ifPresent(resourcePath -> this.leggTilStandardDokumentasjon(swaggerRequest, contextClass, contextClass, (String)resourcePath));
    }

    private void leggTilStandardDokumentasjon(SwaggerRequest swaggerRequest, Class<?> methodsClass, Class<?> contextClass, String resourcePath) {
        Arrays.stream(methodsClass.getMethods()).forEach(method -> this.leggTilStandardDokumentasjon(swaggerRequest, (Method)method, resourcePath, contextClass));
    }

    private void leggTilStandardDokumentasjon(SwaggerRequest swaggerRequest, Method method, String resourcePath, Class<?> contextClass) {
        if (swaggerRequest.methods.contains(method)) {
            return;
        }
        swaggerRequest.methods.add(method);
        String methodPath = Optional.ofNullable(AnnotationUtils.findAnnotation((Method)method, Path.class)).map(Path::value).map(this::prependSlash).orElse("");
        String path = resourcePath + ("/".equals(methodPath) ? "" : methodPath);
        this.leggTilStandardDokumentasjon(swaggerRequest, method.getReturnType(), contextClass, path);
        Optional.ofNullable(swaggerRequest.swagger.getPath(path)).flatMap(swaggerPath -> this.getOperation((io.swagger.models.Path)swaggerPath, method)).ifPresent(operation -> {
            HeaderParameter consumerIdParameter = new HeaderParameter();
            consumerIdParameter.setName("Nav-Consumer-Id");
            consumerIdParameter.setDescription("the consuming entity of the request, typically the name of an application");
            consumerIdParameter.setType("string");
            operation.addParameter((Parameter)consumerIdParameter);
            HeaderParameter callIdParameter = new HeaderParameter();
            callIdParameter.setName("Nav-Call-Id");
            callIdParameter.setDescription("a correlation id that is added to logs associated with the request");
            callIdParameter.setType("string");
            operation.addParameter((Parameter)callIdParameter);
            if (this.hasLogin) {
                HeaderParameter authorizationParameters = new HeaderParameter();
                authorizationParameters.setName("Authorization");
                authorizationParameters.setType("string");
                operation.addParameter((Parameter)authorizationParameters);
                Response response2 = new Response();
                response2.setDescription("the request was not authenticated or authorized");
                operation.response(401, response2);
            }
            operation.getResponses().values().forEach(response -> response.addHeader("Nav-Call-Id", (Property)new StringProperty()));
            if (Optional.ofNullable(operation.getTags()).map(List::isEmpty).orElse(true).booleanValue()) {
                operation.addTag(contextClass.getSimpleName());
            }
            operation.setSummary(Optional.ofNullable(operation.getSummary()).orElse(method.getName()));
        });
    }

    private Optional<Operation> getOperation(io.swagger.models.Path swaggerPath, Method method) {
        Map operationsByMethod = swaggerPath.getOperationMap();
        return Optional.ofNullable(AnnotationUtils.findAnnotation((Method)method, javax.ws.rs.HttpMethod.class)).map(javax.ws.rs.HttpMethod::value).map(HttpMethod::valueOf).map(operationsByMethod::get);
    }

    private String prependSlash(String path) {
        return path.startsWith("/") ? path : "/" + path;
    }

    private static class SwaggerRequest {
        private Set<Method> methods = new HashSet<Method>();
        private final Swagger swagger;

        private SwaggerRequest(Swagger swagger) {
            this.swagger = swagger;
        }
    }
}

