/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.feil;

import java.security.SecureRandom;
import java.util.Optional;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.xml.ws.soap.SOAPFaultException;
import no.nav.apiapp.feil.Feil;
import no.nav.apiapp.feil.FeilDTO;
import no.nav.apiapp.feil.FeilType;
import no.nav.apiapp.soap.SoapFeilMapper;
import no.nav.apiapp.util.EnumUtils;
import no.nav.sbl.util.EnvironmentUtils;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FeilMapper {
    public static final String VIS_DETALJER_VED_FEIL = "VIS_DETALJER_VED_FEIL";
    private static final SecureRandom secureRandom = new SecureRandom();

    public static FeilDTO somFeilDTO(Throwable exception) {
        return FeilMapper.somFeilDTO(exception, FeilMapper.getType(exception));
    }

    public static FeilDTO somFeilDTO(Throwable exception, Feil.Type type) {
        return new FeilDTO(FeilMapper.nyFeilId(), Optional.ofNullable(type).orElse(FeilType.UKJENT).getName(), FeilMapper.visDetaljer() ? FeilMapper.finnDetaljer(exception) : null);
    }

    static String nyFeilId() {
        byte[] bytes = new byte[16];
        secureRandom.nextBytes(bytes);
        return Hex.encodeHexString((byte[])bytes);
    }

    public static Feil.Type getType(Throwable throwable) {
        if (throwable instanceof Feil) {
            return ((Feil)throwable).getType();
        }
        if (throwable instanceof SOAPFaultException) {
            return EnumUtils.valueOfOptional(FeilType.class, ((SOAPFaultException)throwable).getFault().getFaultCodeAsName().getLocalName()).orElse(FeilType.UKJENT);
        }
        if (throwable instanceof IllegalArgumentException) {
            return FeilType.UGYLDIG_REQUEST;
        }
        if (throwable instanceof NotFoundException) {
            return FeilType.FINNES_IKKE;
        }
        if (throwable instanceof NotAuthorizedException) {
            return FeilType.INGEN_TILGANG;
        }
        return FeilType.UKJENT;
    }

    private static FeilDTO.Detaljer finnDetaljer(Throwable exception) {
        return new FeilDTO.Detaljer(exception.getClass().getName(), exception.getMessage(), FeilMapper.finnStackTrace(exception));
    }

    private static String finnStackTrace(Throwable exception) {
        String stackTrace = ExceptionUtils.getStackTrace((Throwable)exception);
        if (exception instanceof SOAPFaultException) {
            return SoapFeilMapper.finnStackTrace((SOAPFaultException)exception);
        }
        return stackTrace;
    }

    public static boolean visDetaljer() {
        return EnvironmentUtils.getOptionalProperty((String)VIS_DETALJER_VED_FEIL, (String[])new String[0]).map(Boolean::parseBoolean).orElse(false) != false || EnvironmentUtils.isEnvironmentClass((EnvironmentUtils.EnviromentClass)EnvironmentUtils.EnviromentClass.T) || EnvironmentUtils.isEnvironmentClass((EnvironmentUtils.EnviromentClass)EnvironmentUtils.EnviromentClass.Q);
    }
}

