/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.servlet.Filter;
import no.nav.apiapp.ApiApplication;
import no.nav.apiapp.config.ApiAppConfigurator;
import no.nav.apiapp.config.StsConfig;
import no.nav.apiapp.util.UrlUtils;
import no.nav.common.oidc.auth.OidcAuthenticationFilter;
import no.nav.common.oidc.auth.OidcAuthenticator;
import no.nav.common.oidc.auth.OidcAuthenticatorConfig;
import no.nav.json.JsonProvider;
import no.nav.sbl.dialogarena.common.jetty.Jetty;
import no.nav.sbl.dialogarena.types.Pingable;
import no.nav.sbl.util.EnvironmentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Konfigurator
implements ApiAppConfigurator {
    private static final Logger log = LoggerFactory.getLogger(Konfigurator.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(Konfigurator.class);
    private final Jetty.JettyBuilder jettyBuilder;
    private final List<OidcAuthenticator> oidcAuthenticators = new ArrayList<OidcAuthenticator>();
    private final List<Consumer<Jetty>> jettyCustomizers = new ArrayList<Consumer<Jetty>>();
    private final List<Consumer<Jetty.JettyBuilder>> jettyBuilderCustomizers = new ArrayList<Consumer<Jetty.JettyBuilder>>();
    private final List<String> publicPaths = new ArrayList<String>();
    private final List<Pingable> pingables = new ArrayList<Pingable>();
    private ObjectMapper objectMapper = JsonProvider.createObjectMapper();

    public Konfigurator(Jetty.JettyBuilder jettyBuilder, ApiApplication apiApplication) {
        this.jettyBuilder = jettyBuilder;
        String apiBasePath = apiApplication.getApiBasePath();
        this.addPublicPath("/internal/.*").addPublicPath("/ws/.*").addPublicPath(UrlUtils.joinPaths(apiBasePath, "/ping")).addPublicPath(UrlUtils.joinPaths(apiBasePath, "swagger.json"));
    }

    @Override
    public ApiAppConfigurator sts() {
        return this.sts(this.defaultStsConfig());
    }

    StsConfig defaultStsConfig() {
        return StsConfig.builder().url(this.getConfigProperty("no.nav.modig.security.sts.url", "SECURITYTOKENSERVICE_URL")).username(this.getConfigProperty("no.nav.modig.security.systemuser.username", EnvironmentUtils.resolveSrvUserPropertyName())).password(this.getConfigProperty("no.nav.modig.security.systemuser.password", EnvironmentUtils.resolverSrvPasswordPropertyName())).build();
    }

    @Override
    public ApiAppConfigurator sts(StsConfig stsConfig) {
        EnvironmentUtils.setProperty((String)"no.nav.modig.security.sts.url", (String)stsConfig.url, (EnvironmentUtils.Type)EnvironmentUtils.Type.PUBLIC);
        EnvironmentUtils.setProperty((String)"no.nav.modig.security.systemuser.username", (String)stsConfig.username, (EnvironmentUtils.Type)EnvironmentUtils.Type.PUBLIC);
        EnvironmentUtils.setProperty((String)"no.nav.modig.security.systemuser.password", (String)stsConfig.password, (EnvironmentUtils.Type)EnvironmentUtils.Type.SECRET);
        return this;
    }

    @Override
    public ApiAppConfigurator addOidcAuthenticator(OidcAuthenticatorConfig config) {
        this.oidcAuthenticators.add(OidcAuthenticator.fromConfig((OidcAuthenticatorConfig)config));
        return this;
    }

    @Override
    public ApiAppConfigurator addPublicPath(String path) {
        this.publicPaths.add(path);
        return this;
    }

    @Override
    public ApiAppConfigurator customizeJetty(Consumer<Jetty> jettyCustomizer) {
        this.jettyCustomizers.add(jettyCustomizer);
        return this;
    }

    @Override
    public ApiAppConfigurator customizeJettyBuilder(Consumer<Jetty.JettyBuilder> jettyBuilderCustomizer) {
        this.jettyBuilderCustomizers.add(jettyBuilderCustomizer);
        return this;
    }

    @Override
    public ApiAppConfigurator selfTest(Pingable pingable) {
        return this.selfTests(Collections.singletonList(pingable));
    }

    @Override
    public ApiAppConfigurator selfTests(Pingable ... pingables) {
        return this.selfTests(Arrays.asList(pingables));
    }

    @Override
    public ApiAppConfigurator selfTests(Collection<? extends Pingable> pingables) {
        this.pingables.addAll(pingables);
        return this;
    }

    @Override
    public ApiAppConfigurator objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    private String getConfigProperty(String primaryProperty, String secondaryProperty) {
        LOGGER.info("reading config-property {} / {}", (Object)primaryProperty, (Object)secondaryProperty);
        return EnvironmentUtils.getOptionalProperty((String)primaryProperty, (String[])new String[0]).orElseGet(() -> EnvironmentUtils.getRequiredProperty((String)secondaryProperty, (String[])new String[0]));
    }

    public Jetty buildJetty() {
        if (!this.oidcAuthenticators.isEmpty()) {
            this.jettyBuilder.addFilter((Filter)new OidcAuthenticationFilter(this.oidcAuthenticators, this.publicPaths));
        }
        this.jettyBuilderCustomizers.forEach(c -> c.accept(this.jettyBuilder));
        Jetty jetty = this.jettyBuilder.buildJetty();
        this.jettyCustomizers.forEach(c -> c.accept(jetty));
        return jetty;
    }

    public boolean hasOidcAuthentication() {
        return !this.oidcAuthenticators.isEmpty();
    }

    public List<Pingable> getPingables() {
        return this.pingables;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

