/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.security;

import java.util.Optional;
import no.nav.apiapp.feil.IngenTilgang;
import no.nav.sbl.dialogarena.common.abac.pep.AbacPersonId;
import no.nav.sbl.dialogarena.common.abac.pep.Pep;
import no.nav.sbl.dialogarena.common.abac.pep.domain.ResourceType;
import no.nav.sbl.dialogarena.common.abac.pep.domain.request.Action;
import no.nav.sbl.dialogarena.common.abac.pep.domain.response.BiasedDecisionResponse;
import no.nav.sbl.dialogarena.common.abac.pep.domain.response.Decision;
import no.nav.sbl.dialogarena.common.abac.pep.exception.PepException;

public class PepClient {
    private final Pep pep;
    private final String applicationDomain;
    private final ResourceType resourceType;

    public PepClient(Pep pep, String applicationDomain, ResourceType resourceType) {
        this.pep = pep;
        this.applicationDomain = applicationDomain;
        this.resourceType = resourceType;
    }

    public String sjekkLesetilgangTilFnr(String fnr) {
        return this.sjekkTilgangTilPerson(AbacPersonId.fnr((String)fnr), Action.ActionId.READ).getId();
    }

    public String sjekkSkrivetilgangTilFnr(String fnr) {
        return this.sjekkTilgangTilPerson(AbacPersonId.fnr((String)fnr), Action.ActionId.WRITE).getId();
    }

    public String sjekkLesetilgangTilAktorId(String aktorId) {
        return this.sjekkTilgangTilPerson(AbacPersonId.aktorId((String)aktorId), Action.ActionId.READ).getId();
    }

    public String sjekkSkrivetilgangTilAktorId(String aktorId) {
        return this.sjekkTilgangTilPerson(AbacPersonId.aktorId((String)aktorId), Action.ActionId.WRITE).getId();
    }

    public void sjekkTilgangTilEnhet(String enhet) throws IngenTilgang, PepException {
        if (!this.harTilgangTilEnhet(enhet)) {
            throw new IngenTilgang(String.format("Ingen tilgang til enhet '%s'", enhet));
        }
    }

    public boolean harTilgangTilEnhet(String enhet) throws PepException {
        BiasedDecisionResponse r = this.pep.harTilgang(this.pep.nyRequest().withResourceType(ResourceType.Enhet).withDomain(this.applicationDomain).withEnhet(Optional.ofNullable(enhet).orElse("")));
        return this.erPermit(r);
    }

    public AbacPersonId sjekkTilgangTilPerson(AbacPersonId personId, Action.ActionId action) throws PepException {
        return this.sjekkTilgangTilPerson(personId, action, this.resourceType);
    }

    public AbacPersonId sjekkTilgangTilPerson(AbacPersonId personId, Action.ActionId action, ResourceType resourceType) {
        return this.sjekkTilgangTilPerson(personId, this.applicationDomain, action, resourceType);
    }

    public AbacPersonId sjekkTilgangTilPerson(AbacPersonId personId, String applicationDomain, Action.ActionId action, ResourceType resourceType) {
        if (this.erPermit(this.pep.harInnloggetBrukerTilgangTilPerson(personId, applicationDomain, action, resourceType))) {
            return personId;
        }
        throw new IngenTilgang();
    }

    private boolean erPermit(BiasedDecisionResponse biasedDecisionResponse) {
        return Optional.ofNullable(biasedDecisionResponse).map(BiasedDecisionResponse::getBiasedDecision).map(d -> d == Decision.Permit).orElse(false);
    }
}

