/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.nav.sbl.util.EnvironmentUtils;
import no.nav.sbl.util.StringUtils;

public class ComplianceEnforcementFilter
implements Filter {
    private static final Set<String> WHITELIST = new HashSet<String>(Arrays.asList("mozilla", "curl"));
    private static final Set<Function<HttpServletRequest, Stream<String>>> RULES = new HashSet<Function>(Arrays.asList(request -> StringUtils.notNullOrEmpty((String)request.getHeader("Nav-Consumer-Id")) ? Stream.empty() : Stream.of("provide consumer id (typically application name) in the header: Nav-Consumer-Id"), request -> StringUtils.notNullOrEmpty((String)request.getHeader("Nav-Call-Id")) ? Stream.empty() : Stream.of("provide call id (a correlation id) in the header: Nav-Call-Id")));
    private final boolean complianceEnforcementIsActive = EnvironmentUtils.isEnvironmentClass((EnvironmentUtils.EnviromentClass)EnvironmentUtils.EnviromentClass.Q) || EnvironmentUtils.isEnvironmentClass((EnvironmentUtils.EnviromentClass)EnvironmentUtils.EnviromentClass.T);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.enforceCompliance(request)) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            List errorMessages = RULES.stream().flatMap(r -> (Stream)r.apply(httpServletRequest)).collect(Collectors.toList());
            if (!errorMessages.isEmpty()) {
                httpServletResponse.setStatus(400);
                httpServletResponse.setContentType("text/plain");
                httpServletResponse.getWriter().write(String.format("This looks like a request from an application that does not conform to the following compliance rules at NAV:%sPlease update your application to follow these rules.\n\nYou will not receive this error in production.", errorMessages.stream().map(s -> " - " + s).collect(Collectors.joining("\n", "\n\n", "\n\n"))));
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private boolean enforceCompliance(ServletRequest request) {
        return this.complianceEnforcementIsActive && this.isApplicationRequest(request) && !this.isInternalRequest(request);
    }

    private boolean isApplicationRequest(ServletRequest servletRequest) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String userAgent = httpServletRequest.getHeader("User-Agent");
        return userAgent == null || WHITELIST.stream().noneMatch(charSequence -> userAgent.toLowerCase().contains((CharSequence)charSequence));
    }

    private boolean isInternalRequest(ServletRequest servletRequest) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        return httpServletRequest.getRequestURI().contains("/internal");
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

