/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.rest;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import no.nav.apiapp.ApiApplication;
import no.nav.apiapp.config.Konfigurator;
import no.nav.apiapp.rest.AlltidJsonFilter;
import no.nav.apiapp.rest.ExceptionMapper;
import no.nav.apiapp.rest.NavMetricsBinder;
import no.nav.apiapp.rest.PingResource;
import no.nav.apiapp.rest.ReadExceptionHandler;
import no.nav.apiapp.rest.SwaggerResource;
import no.nav.json.DateConfiguration;
import no.nav.json.JsonProvider;
import org.springframework.context.ApplicationContext;

public class RestApplication
extends Application {
    private final ApplicationContext applicationContext;
    private final ApiApplication apiApplication;
    private final Konfigurator konfigurator;

    public RestApplication(ApplicationContext applicationContext, ApiApplication apiApplication, Konfigurator konfigurator) {
        this.applicationContext = applicationContext;
        this.apiApplication = apiApplication;
        this.konfigurator = konfigurator;
    }

    public Set<Object> getSingletons() {
        HashSet<Object> singeltons = new HashSet<Object>();
        ExceptionMapper exceptionMapper = new ExceptionMapper();
        singeltons.addAll(Arrays.asList(new Object[]{new JsonProvider(this.konfigurator.getObjectMapper()), new AlltidJsonFilter(), new ReadExceptionHandler(exceptionMapper), exceptionMapper, new NavMetricsBinder(), DateConfiguration.parameterConverterProvider(), new PingResource(), new SwaggerResource(this.apiApplication, this.konfigurator.hasOidcAuthentication())}));
        singeltons.addAll(this.getBeansWithAnnotation(Provider.class));
        singeltons.addAll(this.getBeansWithAnnotation(Path.class));
        return singeltons;
    }

    private Collection<Object> getBeansWithAnnotation(Class<? extends Annotation> aClass) {
        return this.applicationContext.getBeansWithAnnotation(aClass).values();
    }
}

