/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp.security;

import java.util.function.Supplier;
import no.nav.apiapp.feil.IngenTilgang;
import no.nav.sbl.util.fn.DeferredVoid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PepClientComparatorImpl {
    private Logger log = LoggerFactory.getLogger(PepClientComparatorImpl.class);

    public PepClientComparatorImpl() {
    }

    PepClientComparatorImpl(Logger log) {
        this.log = log;
    }

    boolean get(Supplier<Boolean> orginal, Supplier<Boolean> sammenligneMed) {
        boolean isEqual;
        boolean orginalResultat = orginal.get();
        Boolean sammenligneMedResultat = null;
        boolean sammenligneMedFeilet = false;
        try {
            sammenligneMedResultat = sammenligneMed.get();
        }
        catch (Throwable t) {
            sammenligneMedFeilet = true;
            this.log.warn("Feil i kall mot pep for sammenligning", t);
        }
        boolean bl = isEqual = sammenligneMedResultat != null && orginalResultat == sammenligneMedResultat;
        if (!isEqual && !sammenligneMedFeilet && sammenligneMedResultat != null) {
            String expected = orginalResultat ? "permit" : "deny";
            String got = sammenligneMedResultat != false ? "permit" : "deny";
            this.log.warn("Avvik i resultat fra pep sammenligning. Forventet " + expected + " fikk " + got + ".");
        }
        return orginalResultat;
    }

    void get(DeferredVoid orginal, DeferredVoid sammenligneMed) {
        boolean isEqual;
        IngenTilgang ingenTilgangOrginal = null;
        try {
            orginal.get();
        }
        catch (IngenTilgang e) {
            ingenTilgangOrginal = e;
        }
        IngenTilgang ingenTilgangSecondary = null;
        boolean sammenligneMedFeilet = false;
        try {
            sammenligneMed.get();
        }
        catch (IngenTilgang e) {
            ingenTilgangSecondary = e;
        }
        catch (Throwable t) {
            sammenligneMedFeilet = true;
            this.log.warn("Feil i kall mot pep for sammenligning", t);
        }
        boolean bl = isEqual = ingenTilgangOrginal != null && ingenTilgangSecondary != null || ingenTilgangOrginal == null && ingenTilgangSecondary == null;
        if (!isEqual && !sammenligneMedFeilet) {
            String expected = ingenTilgangOrginal != null ? "deny" : "permit";
            String got = ingenTilgangSecondary != null ? "deny" : "permit";
            this.log.warn("Avvik i resultat fra pep sammenligning. Forventet " + expected + " fikk " + got + ".");
        }
        if (ingenTilgangOrginal != null) {
            throw ingenTilgangOrginal;
        }
    }
}

