/*
 * Decompiled with CFR 0.152.
 */
package no.nav.apiapp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.ws.rs.core.Application;
import no.nav.apiapp.ApiApplication;
import no.nav.apiapp.ComplianceEnforcementFilter;
import no.nav.apiapp.ServletUtil;
import no.nav.apiapp.config.Konfigurator;
import no.nav.apiapp.feil.FeilMapper;
import no.nav.apiapp.metrics.PrometheusFilter;
import no.nav.apiapp.metrics.PrometheusServlet;
import no.nav.apiapp.rest.NavCorsFilter;
import no.nav.apiapp.rest.RestApplication;
import no.nav.apiapp.rest.SwaggerResource;
import no.nav.apiapp.rest.SwaggerUIServlet;
import no.nav.apiapp.selftest.IsAliveServlet;
import no.nav.apiapp.selftest.IsReadyServlet;
import no.nav.apiapp.selftest.SelfTestServlet;
import no.nav.apiapp.selftest.impl.LedigDiskPlassHelsesjekk;
import no.nav.apiapp.selftest.impl.STSHelsesjekk;
import no.nav.apiapp.selftest.impl.TruststoreHelsesjekk;
import no.nav.apiapp.soap.SoapServlet;
import no.nav.apiapp.util.UrlUtils;
import no.nav.apiapp.version.Version;
import no.nav.apiapp.version.VersionService;
import no.nav.common.oidc.auth.OidcAuthenticationFilter;
import no.nav.log.LogFilter;
import no.nav.log.LogFilterConfig;
import no.nav.log.LoginfoServlet;
import no.nav.log.MarkerBuilder;
import no.nav.metrics.MetricsClient;
import no.nav.metrics.MetricsConfig;
import no.nav.sbl.dialogarena.common.web.security.DisableCacheHeadersFilter;
import no.nav.sbl.dialogarena.common.web.security.SecurityHeadersFilter;
import no.nav.sbl.dialogarena.common.web.selftest.SelfTestService;
import no.nav.sbl.dialogarena.types.Pingable;
import no.nav.sbl.util.EnvironmentUtils;
import no.nav.sbl.util.LogUtils;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.RequestContextFilter;

public class ApiAppServletContextListener
implements ServletContextListener,
HttpSessionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiAppServletContextListener.class);
    public static final String INTERNAL_IS_ALIVE = "/internal/isAlive";
    public static final String INTERNAL_IS_READY = "/internal/isReady";
    public static final String INTERNAL_SELFTEST = "/internal/selftest";
    public static final String INTERNAL_METRICS = "/internal/metrics";
    public static final String SWAGGER_PATH = "/internal/swagger/";
    public static final String LOGINFO_PATH = "/internal/loginfo";
    public static final String WEBSERVICE_PATH = "/ws/*";
    private final ContextLoaderListener contextLoaderListener = new ContextLoaderListener();
    private final ApiApplication apiApplication;
    private final Konfigurator konfigurator;

    ApiAppServletContextListener(Konfigurator konfigurator, ApiApplication apiApplication) {
        this.konfigurator = konfigurator;
        this.apiApplication = apiApplication;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        LOGGER.info("contextDestroyed");
        ServletContext servletContext = servletContextEvent.getServletContext();
        this.apiApplication.shutdown(servletContext);
        this.contextLoaderListener.contextDestroyed(servletContextEvent);
        LOGGER.info("contextDestroyed - slutt");
        LogUtils.shutDownLogback();
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        List constraintMappings;
        LOGGER.info("contextInitialized");
        VersionService versionService = new VersionService();
        List<Version> versions = versionService.getVersions();
        versions.forEach(v -> new MarkerBuilder().field("component", (Object)v.component).field("version", (Object)v.version).logInfo(LOGGER));
        ServletContext servletContext = servletContextEvent.getServletContext();
        this.konfigurerSpring(servletContext);
        AnnotationConfigWebApplicationContext webApplicationContext = this.startSpring(servletContextEvent);
        ServletUtil.filterBuilder((Filter)new DisableCacheHeadersFilter(DisableCacheHeadersFilter.Config.builder().allowClientStorage(EnvironmentUtils.getPropertyAsBooleanOrElseFalse((String)"ALLOW_CLIENT_STORAGE")).disablePragmaHeader(EnvironmentUtils.getPropertyAsBooleanOrElseFalse((String)"DISABLE_PRAGMA_HEADER")).build())).register(servletContextEvent.getServletContext());
        ConstraintSecurityHandler currentSecurityHandler = (ConstraintSecurityHandler)ConstraintSecurityHandler.getCurrentSecurityHandler();
        List list = constraintMappings = currentSecurityHandler != null ? currentSecurityHandler.getConstraintMappings() : Collections.emptyList();
        if (constraintMappings.size() > 2) {
            List constraints = constraintMappings.subList(2, constraintMappings.size()).stream().map(ConstraintMapping::getConstraint).collect(Collectors.toList());
            throw new IllegalStateException("api-apper bruker ikke container-login lenger, men setter istede opp " + OidcAuthenticationFilter.class.getName() + ". Vennligst fjern security constraints fra web.xml: " + constraints);
        }
        LogFilterConfig logFilterConfig = LogFilterConfig.builder().exposeErrorDetails(FeilMapper::visDetaljer).serverName(EnvironmentUtils.requireApplicationName()).build();
        ServletUtil.filterBuilder(ComplianceEnforcementFilter.class).dispatcherTypes(DispatcherType.REQUEST).urlPatterns(this.apiApplication.getApiBasePath() + "*").register(servletContextEvent);
        ServletUtil.filterBuilder(PrometheusFilter.class).register(servletContext);
        ServletUtil.filterBuilder((Filter)new LogFilter(logFilterConfig)).register(servletContext);
        ServletUtil.filterBuilder(NavCorsFilter.class).register(servletContext);
        ServletUtil.filterBuilder(SecurityHeadersFilter.class).register(servletContext);
        ServletUtil.filterBuilder(RequestContextFilter.class).register(servletContext);
        FilterRegistration.Dynamic characterEncodingRegistration = ServletUtil.filterBuilder(CharacterEncodingFilter.class).register(servletContextEvent.getServletContext());
        characterEncodingRegistration.setInitParameter("encoding", "UTF-8");
        characterEncodingRegistration.setInitParameter("forceEncoding", "true");
        SelfTestService selfTestService = new SelfTestService(this.resolvePingables((WebApplicationContext)webApplicationContext, this.konfigurator));
        ServletUtil.leggTilServlet(servletContextEvent, IsAliveServlet.class, INTERNAL_IS_ALIVE);
        ServletUtil.leggTilServlet(servletContextEvent, (Servlet)new IsReadyServlet(selfTestService), INTERNAL_IS_READY);
        ServletUtil.leggTilServlet(servletContextEvent, (Servlet)new SelfTestServlet(selfTestService), INTERNAL_SELFTEST);
        ServletUtil.leggTilServlet(servletContextEvent, (Servlet)new PrometheusServlet(selfTestService, versions), INTERNAL_METRICS);
        ServletUtil.leggTilServlet(servletContextEvent, (Servlet)new SwaggerUIServlet(this.apiApplication), "/internal/swagger/*");
        ServletUtil.leggTilServlet(servletContextEvent, LoginfoServlet.class, LOGINFO_PATH);
        this.settOppRestApi(servletContextEvent, this.apiApplication, this.konfigurator);
        if (SoapServlet.soapTjenesterEksisterer(servletContext)) {
            ServletUtil.leggTilServlet(servletContextEvent, (Servlet)new SoapServlet(), WEBSERVICE_PATH);
        }
        if (this.sensuMetricsBrukes()) {
            MetricsClient.enableMetrics((MetricsConfig)MetricsConfig.resolveNaisConfig());
        } else {
            LOGGER.info("Sensu metrics deaktivert");
        }
        webApplicationContext.getAutowireCapableBeanFactory().autowireBean((Object)this.apiApplication);
        LOGGER.info("contextInitialized - slutt");
        this.apiApplication.startup(servletContext);
    }

    private Collection<? extends Pingable> resolvePingables(WebApplicationContext webApplicationContext, Konfigurator konfigurator) {
        ArrayList<Object> pingables = new ArrayList<Object>();
        pingables.addAll(webApplicationContext.getBeansOfType(Pingable.class).values());
        pingables.addAll(konfigurator.getPingables());
        return pingables;
    }

    private boolean sensuMetricsBrukes() {
        boolean sensuDisabled = EnvironmentUtils.getOptionalProperty((String)"DISABLE_SENSU_METRICS", (String[])new String[0]).map(Boolean::parseBoolean).orElse(false);
        return !sensuDisabled;
    }

    private boolean stsBrukes() {
        return EnvironmentUtils.getOptionalProperty((String)"no.nav.modig.security.sts.url", (String[])new String[0]).isPresent();
    }

    public void sessionCreated(HttpSessionEvent se) {
        se.getSession().invalidate();
        throw new IllegalStateException("api-apps should be stateless");
    }

    public void sessionDestroyed(HttpSessionEvent se) {
    }

    private void konfigurerSpring(ServletContext servletContext) {
        servletContext.setInitParameter("contextClass", AnnotationConfigWebApplicationContext.class.getName());
        servletContext.setInitParameter("contextConfigLocation", "");
        this.contextLoaderListener.setContextInitializers(new ApplicationContextInitializer[]{applicationContext -> {
            AnnotationConfigWebApplicationContext annotationConfigWebApplicationContext = (AnnotationConfigWebApplicationContext)applicationContext;
            annotationConfigWebApplicationContext.register(new Class[]{this.apiApplication.getClass()});
        }});
    }

    private AnnotationConfigWebApplicationContext startSpring(ServletContextEvent servletContextEvent) {
        this.contextLoaderListener.contextInitialized(servletContextEvent);
        AnnotationConfigWebApplicationContext webApplicationContext = ServletUtil.getSpringContext(servletContextEvent);
        webApplicationContext.getBean(ApiApplication.class);
        this.leggTilBonne(servletContextEvent, new LedigDiskPlassHelsesjekk());
        this.leggTilBonne(servletContextEvent, new TruststoreHelsesjekk());
        if (this.stsBrukes()) {
            this.leggTilBonne(servletContextEvent, new STSHelsesjekk());
        }
        return webApplicationContext;
    }

    private void leggTilBonne(ServletContextEvent servletContextEvent, Object bonne) {
        ServletUtil.getSpringContext(servletContextEvent).getBeanFactory().registerSingleton(bonne.getClass().getName(), bonne);
    }

    private void settOppRestApi(ServletContextEvent servletContextEvent, ApiApplication apiApplication, Konfigurator konfigurator) {
        WebApplicationContext webApplicationContext = ServletUtil.getContext(servletContextEvent.getServletContext());
        RestApplication restApplication = new RestApplication((ApplicationContext)webApplicationContext, apiApplication, konfigurator);
        ServletContainer servlet = new ServletContainer(ResourceConfig.forApplication((Application)restApplication));
        ServletRegistration.Dynamic servletRegistration = ServletUtil.leggTilServlet(servletContextEvent, (Servlet)servlet, UrlUtils.sluttMedSlash(apiApplication.getApiBasePath()) + "*");
        SwaggerResource.setupServlet(servletRegistration);
    }
}

