/*
 * Decompiled with CFR 0.152.
 */
package no.nav.dialogarena.mock;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.eclipse.jetty.util.resource.Resource;

public class JavascriptEngine {
    static void evaluateJavascript(Resource javascript, HttpServletRequest request, HttpServletResponse httpServletResponse) {
        ScriptEngine scriptEngine = new NashornScriptEngineFactory().getScriptEngine();
        try (InputStreamReader reader = new InputStreamReader(javascript.getInputStream());){
            ScriptContext scriptContext = scriptEngine.getContext();
            Response response = new Response(scriptEngine);
            scriptContext.setAttribute("response", response, 100);
            scriptContext.setAttribute("request", Request.create(scriptEngine, request), 100);
            scriptEngine.eval((Reader)reader, scriptContext);
            httpServletResponse.setStatus(response.status);
            response.headers.forEach((arg_0, arg_1) -> ((HttpServletResponse)httpServletResponse).setHeader(arg_0, arg_1));
            response.cookies.forEach(arg_0 -> ((HttpServletResponse)httpServletResponse).addCookie(arg_0));
            httpServletResponse.getWriter().write(response.responseTekst);
        }
    }

    public static class Response {
        private final ScriptEngine scriptEngine;
        private int status = 200;
        private String responseTekst = "";
        private Map<String, String> headers = new HashMap<String, String>();
        private List<Cookie> cookies = new ArrayList<Cookie>();

        public Response(ScriptEngine scriptEngine) {
            this.scriptEngine = scriptEngine;
        }

        public void setStatus(int newStatus) {
            this.status = newStatus;
        }

        public void setHeader(String name, String value) {
            this.headers.put(name, value);
        }

        public void addCookie(String name, String value) {
            Cookie cookie = new Cookie(name, value);
            cookie.setPath("/");
            this.cookies.add(cookie);
        }

        public void setResponseTekst(String responseTekst) {
            this.responseTekst = responseTekst;
        }

        public void setResponseJson(Object response) {
            ScriptObjectMirror json = (ScriptObjectMirror)this.scriptEngine.eval("JSON");
            this.responseTekst = (String)json.callMember("stringify", new Object[]{response});
        }

        public void send(String aString) {
            System.out.println(aString);
        }
    }

    public static class Request {
        public Map<String, String> params = new HashMap<String, String>();

        public Request(HttpServletRequest request) {
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                this.params.put(parameterName, request.getParameter(parameterName));
            }
        }

        public static Object create(ScriptEngine scriptEngine, HttpServletRequest httpServletRequest) {
            String requestHandlerJson = new ObjectMapper().writeValueAsString((Object)new Request(httpServletRequest));
            ScriptObjectMirror json = (ScriptObjectMirror)scriptEngine.eval("JSON");
            return json.callMember("parse", new Object[]{requestHandlerJson});
        }
    }
}

