/*
 * Decompiled with CFR 0.152.
 */
package no.nav.dialogarena.mock;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.nav.dialogarena.mock.JavascriptEngine;
import no.nav.dialogarena.mock.MockServer;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.URLResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockHandler
extends ResourceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MockServer.class);
    private static final String PATH_PATH = "/mockserver";
    private static final List<String> EXTENSIONS = Arrays.asList("json", "xml");
    private final String contextPath;
    private final AtomicLong requestCounter = new AtomicLong();

    public MockHandler(String contextName) {
        this.contextPath = contextName.startsWith("/") ? contextName : "/" + contextName;
        this.setBaseResource(URLResource.newClassPathResource((String)(PATH_PATH + this.contextPath)));
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        long requestNumber = this.requestCounter.incrementAndGet();
        if (this.contextPath.equals(target)) {
            Response response = baseRequest.getResponse();
            response.setContentType("text/plain");
            response.getWriter().write("mock for: " + this.contextPath);
            baseRequest.setHandled(true);
        } else if (target.startsWith(this.contextPath + "/internal/selftest")) {
            httpServletResponse.getWriter().write("OK");
            baseRequest.setHandled(true);
        } else {
            if (this.getResource("/") == null) {
                throw new IOException("Unable to locate /mockserver in resources. Check your configuration.");
            }
            String pathInfo = target.substring(this.contextPath.length()) + "." + baseRequest.getMethod();
            String jsPath = pathInfo + ".js";
            Resource javascript = this.getResource(jsPath);
            if (javascript.exists()) {
                JavascriptEngine.evaluateJavascript(javascript, request, httpServletResponse);
                baseRequest.setHandled(true);
                return;
            }
            for (String extension : EXTENSIONS) {
                String jsonPath = pathInfo + "." + extension;
                if (this.getResource(pathInfo).exists() || !this.getResource(jsonPath).exists()) continue;
                pathInfo = jsonPath;
            }
            baseRequest.setMethod(HttpMethod.GET.name());
            baseRequest.setPathInfo(pathInfo);
            super.handle(target, baseRequest, request, httpServletResponse);
            if (baseRequest.isHandled()) {
                LOG.info("request #{} {}{}", new Object[]{requestNumber, PATH_PATH, pathInfo});
            } else {
                LOG.warn("request #{} {}{} -- NOT FOUND", new Object[]{requestNumber, PATH_PATH, pathInfo});
                httpServletResponse.setStatus(404);
                baseRequest.setHandled(true);
            }
        }
    }

    public long getRequestCount() {
        return this.requestCounter.get();
    }
}

