/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.audit_log.cef;

import java.util.HashMap;
import java.util.Map;
import no.nav.common.audit_log.cef.CefMessage;
import no.nav.common.audit_log.cef.CefMessageEvent;
import no.nav.common.audit_log.cef.CefMessageSeverity;

public class CefMessageBuilder {
    private int version = 0;
    private String deviceVendor;
    private String deviceProduct = "AuditLogger";
    private String deviceVersion = "1.0";
    private String signatureId;
    private String name;
    private String severity;
    private final Map<String, String> extension = new HashMap<String, String>();

    public CefMessageBuilder version(int version) {
        this.version = version;
        return this;
    }

    public CefMessageBuilder applicationName(String applicationName) {
        this.deviceVendor = applicationName;
        return this;
    }

    public CefMessageBuilder loggerName(String loggerName) {
        this.deviceProduct = loggerName;
        return this;
    }

    public CefMessageBuilder logFormatVersion(String logFormatVersion) {
        this.deviceVersion = logFormatVersion;
        return this;
    }

    public CefMessageBuilder event(CefMessageEvent event) {
        this.signatureId = event.type;
        return this;
    }

    public CefMessageBuilder event(String event) {
        this.signatureId = event;
        return this;
    }

    public CefMessageBuilder name(String name) {
        this.name = name;
        return this;
    }

    public CefMessageBuilder severity(CefMessageSeverity severity) {
        this.severity = severity.name();
        return this;
    }

    public CefMessageBuilder severity(String severity) {
        this.severity = severity;
        return this;
    }

    public CefMessageBuilder sourceUserId(String sourceUserId) {
        this.extension.put("suid", sourceUserId);
        return this;
    }

    public CefMessageBuilder destinationUserId(String destinationUserId) {
        this.extension.put("duid", destinationUserId);
        return this;
    }

    public CefMessageBuilder timeEnded(long epochMillis) {
        this.extension.put("end", String.valueOf(epochMillis));
        return this;
    }

    public CefMessageBuilder callId(String callId) {
        this.extension.put("sproc", callId);
        return this;
    }

    public CefMessageBuilder extension(String name, String value) {
        this.extension.put(name, value);
        return this;
    }

    public CefMessageBuilder extensions(Map<String, String> extensions) {
        this.extension.putAll(extensions);
        return this;
    }

    public CefMessageBuilder flexString(int position, String label, String value) {
        if (position < 1 || position > 2) {
            throw new IllegalArgumentException("position must be either 1 or 2");
        }
        this.extension.put(String.format("flexString%dLabel", position), label);
        this.extension.put("flexString" + position, value);
        return this;
    }

    public CefMessageBuilder customString(int position, String label, String value) {
        if (position < 1 || position > 6) {
            throw new IllegalArgumentException("position must be a value from 1 to 6 inclusive");
        }
        this.extension.put(String.format("cs%dLabel", position), label);
        this.extension.put("cs" + position, value);
        return this;
    }

    public CefMessage build() {
        return new CefMessage(this.version, this.deviceVendor, this.deviceProduct, this.deviceVersion, this.signatureId, this.name, this.severity, this.extension);
    }
}

