/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.audit_log.cef;

import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import no.nav.common.audit_log.cef.CefMessageBuilder;

public class CefMessage {
    private final int version;
    private final String deviceVendor;
    private final String deviceProduct;
    private final String deviceVersion;
    private final String signatureId;
    private final String name;
    private final String severity;
    private final Map<String, String> extension;

    public CefMessage(int version, @NonNull String deviceVendor, @NonNull String deviceProduct, @NonNull String deviceVersion, @NonNull String signatureId, @NonNull String name, @NonNull String severity, @NonNull Map<String, String> extension) {
        if (deviceVendor == null) {
            throw new NullPointerException("deviceVendor is marked non-null but is null");
        }
        if (deviceProduct == null) {
            throw new NullPointerException("deviceProduct is marked non-null but is null");
        }
        if (deviceVersion == null) {
            throw new NullPointerException("deviceVersion is marked non-null but is null");
        }
        if (signatureId == null) {
            throw new NullPointerException("signatureId is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (severity == null) {
            throw new NullPointerException("severity is marked non-null but is null");
        }
        if (extension == null) {
            throw new NullPointerException("extension is marked non-null but is null");
        }
        this.version = version;
        this.deviceVendor = deviceVendor;
        this.deviceProduct = deviceProduct;
        this.deviceVersion = deviceVersion;
        this.signatureId = signatureId;
        this.name = name;
        this.severity = severity;
        this.extension = extension;
    }

    public static CefMessageBuilder builder() {
        return new CefMessageBuilder();
    }

    public String toString() {
        String extensionStr = this.extension.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), this.escapeExtensionValue((String)entry.getValue()))).collect(Collectors.joining(" "));
        return String.format("CEF:%d|%s|%s|%s|%s|%s|%s|%s", this.version, this.escapeHeader(this.deviceVendor), this.escapeHeader(this.deviceProduct), this.escapeHeader(this.deviceVersion), this.escapeHeader(this.signatureId), this.escapeHeader(this.name), this.escapeHeader(this.severity), extensionStr);
    }

    private String escapeHeader(String header) {
        return header.replace("\\", "\\\\").replace("|", "\\|");
    }

    private String escapeExtensionValue(String attribute) {
        return attribute.replace("\\", "\\\\").replace("=", "\\=").replace("\n", "\\n");
    }

    public int getVersion() {
        return this.version;
    }

    public String getDeviceVendor() {
        return this.deviceVendor;
    }

    public String getDeviceProduct() {
        return this.deviceProduct;
    }

    public String getDeviceVersion() {
        return this.deviceVersion;
    }

    public String getSignatureId() {
        return this.signatureId;
    }

    public String getName() {
        return this.name;
    }

    public String getSeverity() {
        return this.severity;
    }

    public Map<String, String> getExtension() {
        return this.extension;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CefMessage)) {
            return false;
        }
        CefMessage other = (CefMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$deviceVendor = this.getDeviceVendor();
        String other$deviceVendor = other.getDeviceVendor();
        if (this$deviceVendor == null ? other$deviceVendor != null : !this$deviceVendor.equals(other$deviceVendor)) {
            return false;
        }
        String this$deviceProduct = this.getDeviceProduct();
        String other$deviceProduct = other.getDeviceProduct();
        if (this$deviceProduct == null ? other$deviceProduct != null : !this$deviceProduct.equals(other$deviceProduct)) {
            return false;
        }
        String this$deviceVersion = this.getDeviceVersion();
        String other$deviceVersion = other.getDeviceVersion();
        if (this$deviceVersion == null ? other$deviceVersion != null : !this$deviceVersion.equals(other$deviceVersion)) {
            return false;
        }
        String this$signatureId = this.getSignatureId();
        String other$signatureId = other.getSignatureId();
        if (this$signatureId == null ? other$signatureId != null : !this$signatureId.equals(other$signatureId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$severity = this.getSeverity();
        String other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !this$severity.equals(other$severity)) {
            return false;
        }
        Map<String, String> this$extension = this.getExtension();
        Map<String, String> other$extension = other.getExtension();
        return !(this$extension == null ? other$extension != null : !((Object)this$extension).equals(other$extension));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CefMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVersion();
        String $deviceVendor = this.getDeviceVendor();
        result = result * 59 + ($deviceVendor == null ? 43 : $deviceVendor.hashCode());
        String $deviceProduct = this.getDeviceProduct();
        result = result * 59 + ($deviceProduct == null ? 43 : $deviceProduct.hashCode());
        String $deviceVersion = this.getDeviceVersion();
        result = result * 59 + ($deviceVersion == null ? 43 : $deviceVersion.hashCode());
        String $signatureId = this.getSignatureId();
        result = result * 59 + ($signatureId == null ? 43 : $signatureId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
        Map<String, String> $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : ((Object)$extension).hashCode());
        return result;
    }
}

