/*
 * Decompiled with CFR 0.152.
 */
package no.nav.cache;

import java.beans.ConstructorProperties;
import java.util.concurrent.TimeUnit;

public final class CacheConfig {
    public static final CacheConfig DEFAULT = CacheConfig.builder().build();
    private static final long FIVE_MINUTES = 300000L;
    public final long timeToLiveMillis;
    public final int maxEntries;

    private static long $default$timeToLiveMillis() {
        return 300000L;
    }

    private static int $default$maxEntries() {
        return 1000;
    }

    @ConstructorProperties(value={"timeToLiveMillis", "maxEntries"})
    CacheConfig(long timeToLiveMillis, int maxEntries) {
        this.timeToLiveMillis = timeToLiveMillis;
        this.maxEntries = maxEntries;
    }

    public static CacheConfigBuilder builder() {
        return new CacheConfigBuilder();
    }

    public long getTimeToLiveMillis() {
        return this.timeToLiveMillis;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheConfig)) {
            return false;
        }
        CacheConfig other = (CacheConfig)o;
        if (this.getTimeToLiveMillis() != other.getTimeToLiveMillis()) {
            return false;
        }
        return this.getMaxEntries() == other.getMaxEntries();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeToLiveMillis = this.getTimeToLiveMillis();
        result = result * 59 + (int)($timeToLiveMillis >>> 32 ^ $timeToLiveMillis);
        result = result * 59 + this.getMaxEntries();
        return result;
    }

    public String toString() {
        return "CacheConfig(timeToLiveMillis=" + this.getTimeToLiveMillis() + ", maxEntries=" + this.getMaxEntries() + ")";
    }

    public CacheConfig withTimeToLiveMillis(long timeToLiveMillis) {
        return this.timeToLiveMillis == timeToLiveMillis ? this : new CacheConfig(timeToLiveMillis, this.maxEntries);
    }

    public CacheConfig withMaxEntries(int maxEntries) {
        return this.maxEntries == maxEntries ? this : new CacheConfig(this.timeToLiveMillis, maxEntries);
    }

    public static class CacheConfigBuilder {
        private boolean timeToLiveMillis$set;
        private long timeToLiveMillis;
        private boolean maxEntries$set;
        private int maxEntries;

        public CacheConfigBuilder timeToLive(long millis) {
            return this.timeToLiveMillis(millis);
        }

        public CacheConfigBuilder timeToLive(long duration, TimeUnit timeUnit) {
            return this.timeToLiveMillis(timeUnit.toMillis(duration));
        }

        CacheConfigBuilder() {
        }

        public CacheConfigBuilder timeToLiveMillis(long timeToLiveMillis) {
            this.timeToLiveMillis = timeToLiveMillis;
            this.timeToLiveMillis$set = true;
            return this;
        }

        public CacheConfigBuilder maxEntries(int maxEntries) {
            this.maxEntries = maxEntries;
            this.maxEntries$set = true;
            return this;
        }

        public CacheConfig build() {
            return new CacheConfig(this.timeToLiveMillis$set ? this.timeToLiveMillis : CacheConfig.$default$timeToLiveMillis(), this.maxEntries$set ? this.maxEntries : CacheConfig.$default$maxEntries());
        }

        public String toString() {
            return "CacheConfig.CacheConfigBuilder(timeToLiveMillis=" + this.timeToLiveMillis + ", maxEntries=" + this.maxEntries + ")";
        }
    }
}

