/*
 * Decompiled with CFR 0.152.
 */
package no.nav.cache;

import java.io.Serializable;
import java.util.UUID;
import java.util.function.Function;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import no.nav.cache.Cache;
import no.nav.cache.CacheConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheUtils.class);
    private static final CacheManager CACHE_MANAGER = CacheManager.newInstance((Configuration)new Configuration());

    public static <T> Cache<String, T> buildCache(CacheConfig cacheConfig) {
        return new CacheImpl(CacheUtils.createEhCache(cacheConfig), cacheConfig);
    }

    private static net.sf.ehcache.Cache createEhCache(CacheConfig cacheConfig) {
        long timeToLiveSeconds = cacheConfig.timeToLiveMillis / 1000L;
        CacheConfiguration cacheConfiguration = new CacheConfiguration(UUID.randomUUID().toString(), cacheConfig.maxEntries).memoryStoreEvictionPolicy(MemoryStoreEvictionPolicy.LRU).timeToIdleSeconds(timeToLiveSeconds).timeToLiveSeconds(timeToLiveSeconds);
        CACHE_MANAGER.addCache(new net.sf.ehcache.Cache(cacheConfiguration));
        return CACHE_MANAGER.getCache(cacheConfiguration.getName());
    }

    private static class CacheImpl<T>
    implements Cache<String, T> {
        private final net.sf.ehcache.Cache cache;
        private final long refreshInterval;

        public CacheImpl(net.sf.ehcache.Cache cache, CacheConfig cacheConfig) {
            this.refreshInterval = cacheConfig.timeToLiveMillis / 2L;
            this.cache = cache;
        }

        @Override
        public T get(String key, Function<String, T> function) {
            Element element = this.cache.get((Serializable)((Object)key));
            if (element == null) {
                element = this.update(key, function);
            } else if (this.shouldRefresh(element)) {
                try {
                    element = this.update(key, function);
                }
                catch (Throwable t) {
                    LOGGER.warn("failed to refresh cache", t);
                }
            }
            return (T)element.getObjectValue();
        }

        private boolean shouldRefresh(Element element) {
            return element.getExpirationTime() - this.refreshInterval < System.currentTimeMillis();
        }

        private Element update(String key, Function<String, T> function) {
            Element element = new Element((Object)key, function.apply(key));
            this.cache.put(element);
            return element;
        }
    }
}

